/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;

public class MultiInfoItemsCollector
extends InfoItemsCollector<InfoItem, InfoItemExtractor> {
    private final StreamInfoItemsCollector streamCollector;
    private final ChannelInfoItemsCollector userCollector;
    private final PlaylistInfoItemsCollector playlistCollector;

    public MultiInfoItemsCollector(int serviceId) {
        super(serviceId);
        this.streamCollector = new StreamInfoItemsCollector(serviceId);
        this.userCollector = new ChannelInfoItemsCollector(serviceId);
        this.playlistCollector = new PlaylistInfoItemsCollector(serviceId);
    }

    @Override
    public List<Throwable> getErrors() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>(super.getErrors());
        errors.addAll(this.streamCollector.getErrors());
        errors.addAll(this.userCollector.getErrors());
        errors.addAll(this.playlistCollector.getErrors());
        return Collections.unmodifiableList(errors);
    }

    @Override
    public void reset() {
        super.reset();
        this.streamCollector.reset();
        this.userCollector.reset();
        this.playlistCollector.reset();
    }

    @Override
    public InfoItem extract(InfoItemExtractor extractor) throws ParsingException {
        if (extractor instanceof StreamInfoItemExtractor) {
            return this.streamCollector.extract((StreamInfoItemExtractor)extractor);
        }
        if (extractor instanceof ChannelInfoItemExtractor) {
            return this.userCollector.extract((ChannelInfoItemExtractor)extractor);
        }
        if (extractor instanceof PlaylistInfoItemExtractor) {
            return this.playlistCollector.extract((PlaylistInfoItemExtractor)extractor);
        }
        throw new IllegalArgumentException("Invalid extractor type: " + extractor);
    }
}

