/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.kiosk;

import java.io.IOException;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.ListInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.ExtractorHelper;

public final class KioskInfo
extends ListInfo<StreamInfoItem> {
    private KioskInfo(int serviceId, ListLinkHandler linkHandler, String name) {
        super(serviceId, linkHandler, name);
    }

    public static ListExtractor.InfoItemsPage<StreamInfoItem> getMoreItems(StreamingService service, String url, Page page) throws IOException, ExtractionException {
        return service.getKioskList().getExtractorByUrl(url, page).getPage(page);
    }

    public static KioskInfo getInfo(String url) throws IOException, ExtractionException {
        return KioskInfo.getInfo(NewPipe.getServiceByUrl(url), url);
    }

    public static KioskInfo getInfo(StreamingService service, String url) throws IOException, ExtractionException {
        KioskExtractor extractor = service.getKioskList().getExtractorByUrl(url, null);
        extractor.fetchPage();
        return KioskInfo.getInfo(extractor);
    }

    public static KioskInfo getInfo(KioskExtractor extractor) throws ExtractionException {
        KioskInfo info = new KioskInfo(extractor.getServiceId(), extractor.getLinkHandler(), extractor.getName());
        ListExtractor.InfoItemsPage itemsPage = ExtractorHelper.getItemsPageOrLogError(info, extractor);
        info.setRelatedItems(itemsPage.getItems());
        info.setNextPage(itemsPage.getNextPage());
        return info;
    }
}

