/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.jsoup.Jsoup;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.tabs.ChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ReadyChannelTabListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.linkHandler.BandcampChannelTabLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class BandcampChannelExtractor
extends ChannelExtractor {
    private JsonObject channelInfo;

    public BandcampChannelExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    @Nonnull
    public List<Image> getAvatars() {
        return BandcampExtractorHelper.getImagesFromImageId(this.channelInfo.getLong("bio_image_id"), false);
    }

    @Override
    @Nonnull
    public List<Image> getBanners() throws ParsingException {
        try {
            String html = this.getDownloader().get(Utils.replaceHttpWithHttps(this.channelInfo.getString("bandcamp_url"))).responseBody();
            return Stream.of(Jsoup.parse(html).getElementById("customHeader")).filter(Objects::nonNull).flatMap(element -> element.getElementsByTag("img").stream()).map(element -> element.attr("src")).filter(url -> !url.isEmpty()).map(url -> new Image(Utils.replaceHttpWithHttps(url), -1, -1, Image.ResolutionLevel.UNKNOWN)).collect(Collectors.toUnmodifiableList());
        }
        catch (IOException | ReCaptchaException e) {
            throw new ParsingException("Could not download artist web site", e);
        }
    }

    @Override
    public String getFeedUrl() {
        return null;
    }

    @Override
    public long getSubscriberCount() {
        return -1L;
    }

    @Override
    public String getDescription() {
        return this.channelInfo.getString("bio");
    }

    @Override
    public String getParentChannelName() {
        return null;
    }

    @Override
    public String getParentChannelUrl() {
        return null;
    }

    @Override
    @Nonnull
    public List<Image> getParentChannelAvatars() {
        return List.of();
    }

    @Override
    public boolean isVerified() throws ParsingException {
        return false;
    }

    @Override
    @Nonnull
    public List<ListLinkHandler> getTabs() throws ParsingException {
        JsonArray discography = this.channelInfo.getArray("discography");
        TabExtractorBuilder builder = new TabExtractorBuilder(discography);
        ArrayList<ReadyChannelTabListLinkHandler> tabs = new ArrayList<ReadyChannelTabListLinkHandler>();
        boolean foundTrackItem = false;
        boolean foundAlbumItem = false;
        for (Object discographyItem : discography) {
            if (foundTrackItem && foundAlbumItem) break;
            if (!(discographyItem instanceof JsonObject)) continue;
            JsonObject discographyJsonItem = (JsonObject)discographyItem;
            String itemType = discographyJsonItem.getString("item_type");
            if (!foundTrackItem && "track".equals(itemType)) {
                foundTrackItem = true;
                tabs.add(new ReadyChannelTabListLinkHandler(this.getUrl() + BandcampChannelTabLinkHandlerFactory.getUrlSuffix("tracks"), this.getId(), "tracks", builder));
            }
            if (foundAlbumItem || !"album".equals(itemType)) continue;
            foundAlbumItem = true;
            tabs.add(new ReadyChannelTabListLinkHandler(this.getUrl() + BandcampChannelTabLinkHandlerFactory.getUrlSuffix("albums"), this.getId(), "albums", builder));
        }
        return Collections.unmodifiableList(tabs);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        this.channelInfo = BandcampExtractorHelper.getArtistDetails(this.getId());
    }

    @Override
    @Nonnull
    public String getName() {
        return this.channelInfo.getString("name");
    }

    private static final class TabExtractorBuilder
    implements ReadyChannelTabListLinkHandler.ChannelTabExtractorBuilder {
        private final JsonArray discography;

        TabExtractorBuilder(JsonArray discography) {
            this.discography = discography;
        }

        @Override
        @Nonnull
        public ChannelTabExtractor build(@Nonnull StreamingService service, @Nonnull ListLinkHandler linkHandler) {
            return BandcampChannelTabExtractor.fromDiscography(service, linkHandler, this.discography);
        }
    }
}

