/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.jsoup.Jsoup;
import org.watermedia.shaded.jsoup.nodes.Document;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.jsoup.select.Elements;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.PaidContentException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampStreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.streaminfoitem.BandcampPlaylistStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;

public class BandcampPlaylistExtractor
extends PlaylistExtractor {
    private static final int MAXIMUM_INDIVIDUAL_COVER_ARTS = 10;
    private Document document;
    private JsonObject albumJson;
    private JsonArray trackInfo;
    private String name;

    public BandcampPlaylistExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        String html = downloader.get(this.getLinkHandler().getUrl()).responseBody();
        this.document = Jsoup.parse(html);
        this.albumJson = BandcampStreamExtractor.getAlbumInfoJson(html);
        this.trackInfo = this.albumJson.getArray("trackinfo");
        try {
            this.name = JsonUtils.getJsonData(html, "data-embed").getString("album_title");
        }
        catch (JsonParserException e) {
            throw new ParsingException("Faulty JSON; page likely does not contain album data", e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParsingException("JSON does not exist", e);
        }
        if (this.trackInfo.isEmpty()) {
            throw new PaidContentException("Album needs to be purchased");
        }
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        if (this.albumJson.isNull("art_id")) {
            return List.of();
        }
        return BandcampExtractorHelper.getImagesFromImageId(this.albumJson.getLong("art_id"), true);
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        String[] parts = this.getUrl().split("/");
        return "https://" + parts[2] + "/";
    }

    @Override
    public String getUploaderName() {
        return this.albumJson.getString("artist");
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() {
        return BandcampExtractorHelper.getImagesFromImageUrl(this.document.getElementsByClass("band-photo").stream().map(element -> element.attr("src")).findFirst().orElse(""));
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    @Override
    public long getStreamCount() {
        return this.trackInfo.size();
    }

    @Override
    @Nonnull
    public Description getDescription() throws ParsingException {
        Element tInfo = this.document.getElementById("trackInfo");
        if (tInfo == null) {
            throw new ParsingException("Could not find trackInfo in document");
        }
        Elements about = tInfo.getElementsByClass("tralbum-about");
        Elements credits = tInfo.getElementsByClass("tralbum-credits");
        Element license = this.document.getElementById("license");
        if (about.isEmpty() && credits.isEmpty() && license == null) {
            return Description.EMPTY_DESCRIPTION;
        }
        StringBuilder sb = new StringBuilder();
        if (!about.isEmpty()) {
            sb.append(Objects.requireNonNull(about.first()).html());
        }
        if (!credits.isEmpty()) {
            sb.append(Objects.requireNonNull(credits.first()).html());
        }
        if (license != null) {
            sb.append(license.html());
        }
        return new Description(sb.toString(), 1);
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<StreamInfoItem> getInitialPage() throws ExtractionException {
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
        for (int i = 0; i < this.trackInfo.size(); ++i) {
            JsonObject track = this.trackInfo.getObject(i);
            if (this.trackInfo.size() < 10) {
                collector.commit(new BandcampPlaylistStreamInfoItemExtractor(track, this.getUploaderUrl(), this.getService()));
                continue;
            }
            collector.commit(new BandcampPlaylistStreamInfoItemExtractor(track, this.getUploaderUrl(), this.getThumbnails()));
        }
        return new ListExtractor.InfoItemsPage<StreamInfoItem>(collector, null);
    }

    @Override
    public ListExtractor.InfoItemsPage<StreamInfoItem> getPage(Page page) {
        return null;
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return this.name;
    }
}

