/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.streaminfoitem;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.streaminfoitem.BandcampStreamInfoItemExtractor;

public class BandcampDiscographStreamInfoItemExtractor
extends BandcampStreamInfoItemExtractor {
    private final JsonObject discograph;

    public BandcampDiscographStreamInfoItemExtractor(JsonObject discograph, String uploaderUrl) {
        super(uploaderUrl);
        this.discograph = discograph;
    }

    @Override
    public String getUploaderName() {
        return this.discograph.getString("band_name");
    }

    @Override
    public String getName() {
        return this.discograph.getString("title");
    }

    @Override
    public String getUrl() throws ParsingException {
        return BandcampExtractorHelper.getStreamUrlFromIds(this.discograph.getLong("band_id"), this.discograph.getLong("item_id"), this.discograph.getString("item_type"));
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return BandcampExtractorHelper.getImagesFromImageId(this.discograph.getLong("art_id"), true);
    }

    @Override
    public long getDuration() {
        return -1L;
    }
}

