/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.MediaFormat;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors.MediaCCCParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.AudioStream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.DeliveryMethod;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Stream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.VideoStream;

public class MediaCCCLiveStreamExtractor
extends StreamExtractor {
    private static final String STREAMS = "streams";
    private static final String URLS = "urls";
    private static final String URL = "url";
    private JsonObject conference = null;
    private String group = "";
    private JsonObject room = null;

    public MediaCCCLiveStreamExtractor(StreamingService service, LinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        JsonArray doc = MediaCCCParsingHelper.getLiveStreams(downloader, this.getExtractorLocalization());
        for (int c = 0; c < doc.size(); ++c) {
            JsonObject conferenceObject = doc.getObject(c);
            JsonArray groups = conferenceObject.getArray("groups");
            for (int g = 0; g < groups.size(); ++g) {
                String groupObject = groups.getObject(g).getString("group");
                JsonArray rooms = groups.getObject(g).getArray("rooms");
                for (int r = 0; r < rooms.size(); ++r) {
                    JsonObject roomObject = rooms.getObject(r);
                    if (!this.getId().equals(conferenceObject.getString("slug") + "/" + roomObject.getString("slug"))) continue;
                    this.conference = conferenceObject;
                    this.group = groupObject;
                    this.room = roomObject;
                    return;
                }
            }
        }
        throw new ExtractionException("Could not find room matching id: '" + this.getId() + "'");
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return this.room.getString("display");
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return MediaCCCParsingHelper.getThumbnailsFromLiveStreamItem(this.room);
    }

    @Override
    @Nonnull
    public Description getDescription() throws ParsingException {
        return new Description(this.conference.getString("description") + " - " + this.group, 3);
    }

    @Override
    public long getViewCount() {
        return -1L;
    }

    @Override
    @Nonnull
    public String getUploaderUrl() throws ParsingException {
        return "https://streaming.media.ccc.de/" + this.conference.getString("slug");
    }

    @Override
    @Nonnull
    public String getUploaderName() throws ParsingException {
        return this.conference.getString("conference");
    }

    @Override
    @Nonnull
    public String getDashMpdUrl() throws ParsingException {
        return this.getManifestOfDeliveryMethodWanted("dash");
    }

    @Override
    @Nonnull
    public String getHlsUrl() {
        return this.getManifestOfDeliveryMethodWanted("hls");
    }

    @Nonnull
    private String getManifestOfDeliveryMethodWanted(@Nonnull String deliveryMethod) {
        return this.room.getArray(STREAMS).stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(streamObject -> streamObject.getObject(URLS)).filter(urls -> urls.has(deliveryMethod)).map(urls -> urls.getObject(deliveryMethod).getString(URL, "")).findFirst().orElse("");
    }

    @Override
    public List<AudioStream> getAudioStreams() throws IOException, ExtractionException {
        return this.getStreams("audio", dto -> {
            AudioStream.Builder builder = new AudioStream.Builder().setId(dto.urlValue.getString("tech", " ")).setContent(dto.urlValue.getString(URL), true).setAverageBitrate(-1);
            if ("hls".equals(dto.urlKey)) {
                return builder.setDeliveryMethod(DeliveryMethod.HLS).build();
            }
            return builder.setMediaFormat(MediaFormat.getFromSuffix(dto.urlKey)).build();
        });
    }

    @Override
    public List<VideoStream> getVideoStreams() throws IOException, ExtractionException {
        return this.getStreams("video", dto -> {
            JsonArray videoSize = dto.streamJsonObj.getArray("videoSize");
            VideoStream.Builder builder = new VideoStream.Builder().setId(dto.urlValue.getString("tech", " ")).setContent(dto.urlValue.getString(URL), true).setIsVideoOnly(false).setResolution(videoSize.getInt(0) + "x" + videoSize.getInt(1));
            if ("hls".equals(dto.urlKey)) {
                return builder.setDeliveryMethod(DeliveryMethod.HLS).build();
            }
            return builder.setMediaFormat(MediaFormat.getFromSuffix(dto.urlKey)).build();
        });
    }

    private <T extends Stream> List<T> getStreams(@Nonnull String streamType, @Nonnull Function<MediaCCCLiveStreamMapperDTO, T> converter) {
        return this.room.getArray(STREAMS).stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(streamJsonObj -> streamType.equals(streamJsonObj.getString("type"))).flatMap(streamJsonObj -> streamJsonObj.getObject(URLS).entrySet().stream().filter(e -> e.getValue() instanceof JsonObject).map(e -> new MediaCCCLiveStreamMapperDTO((JsonObject)streamJsonObj, (String)e.getKey(), (JsonObject)e.getValue()))).filter(dto -> !"dash".equals(dto.urlKey)).map(converter).collect(Collectors.toList());
    }

    @Override
    public List<VideoStream> getVideoOnlyStreams() {
        return Collections.emptyList();
    }

    @Override
    public StreamType getStreamType() throws ParsingException {
        return StreamType.LIVE_STREAM;
    }

    @Override
    @Nonnull
    public String getCategory() {
        return this.group;
    }

    private static final class MediaCCCLiveStreamMapperDTO {
        final JsonObject streamJsonObj;
        final String urlKey;
        final JsonObject urlValue;

        MediaCCCLiveStreamMapperDTO(JsonObject streamJsonObj, String urlKey, JsonObject urlValue) {
            this.streamJsonObj = streamJsonObj;
            this.urlKey = urlKey;
            this.urlValue = urlValue;
        }
    }
}

