/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors.MediaCCCParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;

public class MediaCCCLiveStreamKioskExtractor
implements StreamInfoItemExtractor {
    private final JsonObject conferenceInfo;
    private final String group;
    private final JsonObject roomInfo;

    public MediaCCCLiveStreamKioskExtractor(JsonObject conferenceInfo, String group, JsonObject roomInfo) {
        this.conferenceInfo = conferenceInfo;
        this.group = group;
        this.roomInfo = roomInfo;
    }

    @Override
    public String getName() throws ParsingException {
        return this.roomInfo.getObject("talks").getObject("current").getString("title");
    }

    @Override
    public String getUrl() throws ParsingException {
        return this.roomInfo.getString("link");
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return MediaCCCParsingHelper.getThumbnailsFromLiveStreamItem(this.roomInfo);
    }

    @Override
    public StreamType getStreamType() throws ParsingException {
        boolean isVideo = false;
        for (Object stream : this.roomInfo.getArray("streams")) {
            if (!"video".equals(((JsonObject)stream).getString("type"))) continue;
            isVideo = true;
            break;
        }
        return isVideo ? StreamType.LIVE_STREAM : StreamType.AUDIO_LIVE_STREAM;
    }

    @Override
    public boolean isAd() throws ParsingException {
        return false;
    }

    @Override
    public long getDuration() throws ParsingException {
        return 0L;
    }

    @Override
    public long getViewCount() throws ParsingException {
        return -1L;
    }

    @Override
    public String getUploaderName() throws ParsingException {
        return this.conferenceInfo.getString("conference") + " - " + this.group + " - " + this.roomInfo.getString("display");
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        return "https://media.ccc.de/c/" + this.conferenceInfo.getString("slug");
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    @Override
    @Nullable
    public String getTextualUploadDate() throws ParsingException {
        return null;
    }

    @Override
    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        return null;
    }
}

