/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors;

import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class MediaCCCParsingHelper {
    private static final Pattern LIVE_STREAM_ID_PATTERN = Pattern.compile("\\w+/\\w+");
    private static JsonArray liveStreams = null;

    private MediaCCCParsingHelper() {
    }

    public static OffsetDateTime parseDateFrom(String textualUploadDate) throws ParsingException {
        try {
            return OffsetDateTime.parse(textualUploadDate);
        }
        catch (DateTimeParseException e) {
            throw new ParsingException("Could not parse date: \"" + textualUploadDate + "\"", e);
        }
    }

    public static boolean isLiveStreamId(String id2) {
        return LIVE_STREAM_ID_PATTERN.matcher(id2).find();
    }

    public static JsonArray getLiveStreams(Downloader downloader, Localization localization) throws ExtractionException {
        if (liveStreams == null) {
            try {
                String site = downloader.get("https://streaming.media.ccc.de/streams/v2.json", localization).responseBody();
                liveStreams = JsonParser.array().from(site);
            }
            catch (IOException | ReCaptchaException e) {
                throw new ExtractionException("Could not get live stream JSON.", e);
            }
            catch (JsonParserException e) {
                throw new ExtractionException("Could not parse JSON.", e);
            }
        }
        return liveStreams;
    }

    @Nonnull
    public static List<Image> getImageListFromLogoImageUrl(@Nullable String logoImageUrl) {
        if (Utils.isNullOrEmpty(logoImageUrl)) {
            return List.of();
        }
        return List.of(new Image(logoImageUrl, -1, -1, Image.ResolutionLevel.UNKNOWN));
    }

    @Nonnull
    public static List<Image> getThumbnailsFromStreamItem(@Nonnull JsonObject streamItem) {
        return MediaCCCParsingHelper.getThumbnailsFromObject(streamItem, "thumb_url", "poster_url");
    }

    @Nonnull
    public static List<Image> getThumbnailsFromLiveStreamItem(@Nonnull JsonObject liveStreamItem) {
        return MediaCCCParsingHelper.getThumbnailsFromObject(liveStreamItem, "thumb", "poster");
    }

    @Nonnull
    private static List<Image> getThumbnailsFromObject(@Nonnull JsonObject streamOrLivestreamItem, @Nonnull String thumbUrlKey, @Nonnull String posterUrlKey) {
        String posterUrl;
        ArrayList<Image> imageList = new ArrayList<Image>(2);
        String thumbUrl = streamOrLivestreamItem.getString(thumbUrlKey);
        if (!Utils.isNullOrEmpty(thumbUrl)) {
            imageList.add(new Image(thumbUrl, -1, -1, Image.ResolutionLevel.MEDIUM));
        }
        if (!Utils.isNullOrEmpty(posterUrl = streamOrLivestreamItem.getString(posterUrlKey))) {
            imageList.add(new Image(posterUrl, -1, -1, Image.ResolutionLevel.HIGH));
        }
        return Collections.unmodifiableList(imageList);
    }
}

