/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.linkHandler;

import java.util.List;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;

public final class MediaCCCConferenceLinkHandlerFactory
extends ListLinkHandlerFactory {
    private static final MediaCCCConferenceLinkHandlerFactory INSTANCE = new MediaCCCConferenceLinkHandlerFactory();
    public static final String CONFERENCE_API_ENDPOINT = "https://api.media.ccc.de/public/conferences/";
    public static final String CONFERENCE_PATH = "https://media.ccc.de/c/";
    private static final String ID_PATTERN = "(?:(?:(?:api\\.)?media\\.ccc\\.de/public/conferences/)|(?:media\\.ccc\\.de/[bc]/))([^/?&#]*)";

    private MediaCCCConferenceLinkHandlerFactory() {
    }

    public static MediaCCCConferenceLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getUrl(String id2, List<String> contentFilter, String sortFilter) throws ParsingException, UnsupportedOperationException {
        return CONFERENCE_PATH + id2;
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        return Parser.matchGroup1(ID_PATTERN, url);
    }

    @Override
    public boolean onAcceptUrl(String url) {
        try {
            return this.getId(url) != null;
        }
        catch (ParsingException e) {
            return false;
        }
    }

    @Override
    public String[] getAvailableContentFilter() {
        return new String[]{"videos"};
    }
}

