/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.PeertubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class PeertubePlaylistInfoItemExtractor
implements PlaylistInfoItemExtractor {
    private final JsonObject item;
    private final JsonObject uploader;
    private final String baseUrl;

    public PeertubePlaylistInfoItemExtractor(@Nonnull JsonObject item, @Nonnull String baseUrl) {
        this.item = item;
        this.uploader = item.getObject("uploader");
        this.baseUrl = baseUrl;
    }

    @Override
    public String getName() throws ParsingException {
        return this.item.getString("displayName");
    }

    @Override
    public String getUrl() throws ParsingException {
        return this.item.getString("url");
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return PeertubeParsingHelper.getThumbnailsFromPlaylistOrVideoItem(this.baseUrl, this.item);
    }

    @Override
    public String getUploaderName() throws ParsingException {
        return this.uploader.getString("displayName");
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        return this.uploader.getString("url");
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    @Override
    public long getStreamCount() throws ParsingException {
        return this.item.getInt("videosLength");
    }

    @Override
    @Nonnull
    public Description getDescription() throws ParsingException {
        String description = this.item.getString("description");
        if (Utils.isNullOrEmpty(description)) {
            return Description.EMPTY_DESCRIPTION;
        }
        return new Description(description, 3);
    }
}

