/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.watermedia.shaded.schabi.newpipe.extractor.ServiceList;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;

public final class PeertubeTrendingLinkHandlerFactory
extends ListLinkHandlerFactory {
    private static final PeertubeTrendingLinkHandlerFactory INSTANCE = new PeertubeTrendingLinkHandlerFactory();
    public static final String KIOSK_TRENDING = "Trending";
    public static final String KIOSK_MOST_LIKED = "Most liked";
    public static final String KIOSK_RECENT = "Recently added";
    public static final String KIOSK_LOCAL = "Local";
    public static final Map<String, String> KIOSK_MAP = Map.of("Trending", "%s/api/v1/videos?sort=-trending", "Most liked", "%s/api/v1/videos?sort=-likes", "Recently added", "%s/api/v1/videos?sort=-publishedAt", "Local", "%s/api/v1/videos?sort=-publishedAt&isLocal=true");

    private PeertubeTrendingLinkHandlerFactory() {
    }

    public static PeertubeTrendingLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getUrl(String id2, List<String> contentFilters, String sortFilter) throws ParsingException, UnsupportedOperationException {
        return this.getUrl(id2, contentFilters, sortFilter, ServiceList.PeerTube.getBaseUrl());
    }

    @Override
    public String getUrl(String id2, List<String> contentFilters, String sortFilter, String baseUrl) throws ParsingException, UnsupportedOperationException {
        return String.format(KIOSK_MAP.get(id2), baseUrl);
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        String cleanUrl = url.replace(ServiceList.PeerTube.getBaseUrl(), "%s");
        if (cleanUrl.contains("/videos/trending")) {
            return KIOSK_TRENDING;
        }
        if (cleanUrl.contains("/videos/most-liked")) {
            return KIOSK_MOST_LIKED;
        }
        if (cleanUrl.contains("/videos/recently-added")) {
            return KIOSK_RECENT;
        }
        if (cleanUrl.contains("/videos/local")) {
            return KIOSK_LOCAL;
        }
        return KIOSK_MAP.entrySet().stream().filter(entry -> cleanUrl.equals(entry.getValue())).findFirst().map(Map.Entry::getKey).orElseThrow(() -> new ParsingException("no id found for this url"));
    }

    @Override
    public boolean onAcceptUrl(String url) {
        try {
            new URL(url);
            return url.contains("/videos?") || url.contains("/videos/trending") || url.contains("/videos/most-liked") || url.contains("/videos/recently-added") || url.contains("/videos/local");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

