/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.suggestion.SuggestionExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class SoundcloudSuggestionExtractor
extends SuggestionExtractor {
    public SoundcloudSuggestionExtractor(StreamingService service) {
        super(service);
    }

    @Override
    public List<String> suggestionList(String query) throws IOException, ExtractionException {
        ArrayList<String> suggestions = new ArrayList<String>();
        Downloader dl = NewPipe.getDownloader();
        String url = "https://api-v2.soundcloud.com/search/queries?q=" + Utils.encodeUrlUtf8(query) + "&client_id=" + SoundcloudParsingHelper.clientId() + "&limit=10";
        String response = dl.get(url, this.getExtractorLocalization()).responseBody();
        try {
            JsonArray collection = JsonParser.object().from(response).getArray("collection");
            for (Object suggestion : collection) {
                if (!(suggestion instanceof JsonObject)) continue;
                suggestions.add(((JsonObject)suggestion).getString("query"));
            }
            return suggestions;
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
    }
}

