/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.dashmanifestcreators;

import java.util.Objects;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.ItagItem;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.dashmanifestcreators.CreationException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.dashmanifestcreators.YoutubeDashManifestCreatorsUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.ManifestCreatorCache;

public final class YoutubeProgressiveDashManifestCreator {
    private static final ManifestCreatorCache<String, String> PROGRESSIVE_STREAMS_CACHE = new ManifestCreatorCache();

    private YoutubeProgressiveDashManifestCreator() {
    }

    @Nonnull
    public static String fromProgressiveStreamingUrl(@Nonnull String progressiveStreamingBaseUrl, @Nonnull ItagItem itagItem, long durationSecondsFallback) throws CreationException {
        long streamDuration;
        if (PROGRESSIVE_STREAMS_CACHE.containsKey(progressiveStreamingBaseUrl)) {
            return Objects.requireNonNull(PROGRESSIVE_STREAMS_CACHE.get(progressiveStreamingBaseUrl)).getSecond();
        }
        long itagItemDuration = itagItem.getApproxDurationMs();
        if (itagItemDuration != -1L) {
            streamDuration = itagItemDuration;
        } else if (durationSecondsFallback > 0L) {
            streamDuration = durationSecondsFallback * 1000L;
        } else {
            throw CreationException.couldNotAddElement("MPD", "the duration of the stream could not be determined and durationSecondsFallback is <= 0");
        }
        Document doc = YoutubeDashManifestCreatorsUtils.generateDocumentAndDoCommonElementsGeneration(itagItem, streamDuration);
        YoutubeProgressiveDashManifestCreator.generateBaseUrlElement(doc, progressiveStreamingBaseUrl);
        YoutubeProgressiveDashManifestCreator.generateSegmentBaseElement(doc, itagItem);
        YoutubeProgressiveDashManifestCreator.generateInitializationElement(doc, itagItem);
        return YoutubeDashManifestCreatorsUtils.buildAndCacheResult(progressiveStreamingBaseUrl, doc, PROGRESSIVE_STREAMS_CACHE);
    }

    @Nonnull
    public static ManifestCreatorCache<String, String> getCache() {
        return PROGRESSIVE_STREAMS_CACHE;
    }

    private static void generateBaseUrlElement(@Nonnull Document doc, @Nonnull String baseUrl) throws CreationException {
        try {
            Element representationElement = (Element)doc.getElementsByTagName("Representation").item(0);
            Element baseURLElement = doc.createElement("BaseURL");
            baseURLElement.setTextContent(baseUrl);
            representationElement.appendChild(baseURLElement);
        }
        catch (DOMException e) {
            throw CreationException.couldNotAddElement("BaseURL", e);
        }
    }

    private static void generateSegmentBaseElement(@Nonnull Document doc, @Nonnull ItagItem itagItem) throws CreationException {
        try {
            Element representationElement = (Element)doc.getElementsByTagName("Representation").item(0);
            Element segmentBaseElement = doc.createElement("SegmentBase");
            String range = itagItem.getIndexStart() + "-" + itagItem.getIndexEnd();
            if (itagItem.getIndexStart() < 0 || itagItem.getIndexEnd() < 0) {
                throw CreationException.couldNotAddElement("SegmentBase", "ItagItem's indexStart or indexEnd are < 0: " + range);
            }
            YoutubeDashManifestCreatorsUtils.setAttribute(segmentBaseElement, doc, "indexRange", range);
            representationElement.appendChild(segmentBaseElement);
        }
        catch (DOMException e) {
            throw CreationException.couldNotAddElement("SegmentBase", e);
        }
    }

    private static void generateInitializationElement(@Nonnull Document doc, @Nonnull ItagItem itagItem) throws CreationException {
        try {
            Element segmentBaseElement = (Element)doc.getElementsByTagName("SegmentBase").item(0);
            Element initializationElement = doc.createElement("Initialization");
            String range = itagItem.getInitStart() + "-" + itagItem.getInitEnd();
            if (itagItem.getInitStart() < 0 || itagItem.getInitEnd() < 0) {
                throw CreationException.couldNotAddElement("Initialization", "ItagItem's initStart and/or initEnd are/is < 0: " + range);
            }
            YoutubeDashManifestCreatorsUtils.setAttribute(initializationElement, doc, "range", range);
            segmentBaseElement.appendChild(initializationElement);
        }
        catch (DOMException e) {
            throw CreationException.couldNotAddElement("Initialization", e);
        }
    }
}

