/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeMusicArtistInfoItemExtractor
implements ChannelInfoItemExtractor {
    private final JsonObject artistInfoItem;

    public YoutubeMusicArtistInfoItemExtractor(JsonObject artistInfoItem) {
        this.artistInfoItem = artistInfoItem;
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        try {
            return YoutubeParsingHelper.getImagesFromThumbnailsArray(this.artistInfoItem.getObject("thumbnail").getObject("musicThumbnailRenderer").getObject("thumbnail").getArray("thumbnails"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get thumbnails", e);
        }
    }

    @Override
    public String getName() throws ParsingException {
        String name = YoutubeParsingHelper.getTextFromObject(this.artistInfoItem.getArray("flexColumns").getObject(0).getObject("musicResponsiveListItemFlexColumnRenderer").getObject("text"));
        if (!Utils.isNullOrEmpty(name)) {
            return name;
        }
        throw new ParsingException("Could not get name");
    }

    @Override
    public String getUrl() throws ParsingException {
        String url = YoutubeParsingHelper.getUrlFromNavigationEndpoint(this.artistInfoItem.getObject("navigationEndpoint"));
        if (!Utils.isNullOrEmpty(url)) {
            return url;
        }
        throw new ParsingException("Could not get URL");
    }

    @Override
    public long getSubscriberCount() throws ParsingException {
        JsonArray flexColumns = this.artistInfoItem.getArray("flexColumns");
        JsonArray runs = flexColumns.getObject(flexColumns.size() - 1).getObject("musicResponsiveListItemFlexColumnRenderer").getObject("text").getArray("runs");
        String subscriberCount = runs.getObject(runs.size() - 1).getString("text");
        if (!Utils.isNullOrEmpty(subscriberCount)) {
            try {
                return Utils.mixedNumberWordToLong(subscriberCount);
            }
            catch (Parser.RegexException ignored) {
                return 0L;
            }
        }
        throw new ParsingException("Could not get subscriber count");
    }

    @Override
    public long getStreamCount() {
        return -1L;
    }

    @Override
    public boolean isVerified() {
        return true;
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }
}

