/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block;

import com.starfish_studios.yaf.block.entity.AbstractDrawerBlockEntity;
import com.starfish_studios.yaf.block.properties.CountertopType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDrawerBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public final Item plankBlock;

    public AbstractDrawerBlock(Item plank, BlockBehaviour.Properties properties) {
        super(properties);
        this.plankBlock = plank;
    }

    public Item getPlanks() {
        return this.plankBlock;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return Shapes.m_83144_();
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!level.f_46443_) {
            Item handItem = player.m_21205_().m_41720_();
            Stream<CountertopType> counterTops = Arrays.stream(CountertopType.values());
            List<CountertopType> filtered = counterTops.filter(type -> type.getItem() == handItem).toList();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof AbstractDrawerBlockEntity) {
                AbstractDrawerBlockEntity blockEntity2 = (AbstractDrawerBlockEntity)blockEntity;
                CountertopType currentCounterTop = blockEntity2.countertopType;
                if (!filtered.isEmpty()) {
                    CountertopType newCounterTop = filtered.get(0);
                    CountertopType defaultCounterTop = CountertopType.getFromBlock(((AbstractDrawerBlock)state.m_60734_()).getPlanks());
                    if (newCounterTop != currentCounterTop) {
                        if (currentCounterTop != defaultCounterTop) {
                            Containers.m_18992_((Level)level, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.9), (double)((double)pos.m_123343_() + 0.5), (ItemStack)new ItemStack((ItemLike)currentCounterTop.getItem()));
                        }
                        if (newCounterTop != defaultCounterTop && !player.m_7500_()) {
                            player.m_21205_().m_41774_(1);
                        }
                        blockEntity2.countertopType = newCounterTop;
                        blockEntity2.m_6596_();
                        return InteractionResult.SUCCESS;
                    }
                }
            }
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction hitLoc = hit.m_82434_();
        if (blockEntity instanceof AbstractDrawerBlockEntity) {
            AbstractDrawerBlockEntity drawerBlockEntity = (AbstractDrawerBlockEntity)blockEntity;
            if (facing == hitLoc) {
                if (!level.f_46443_) {
                    player.m_5893_((MenuProvider)drawerBlockEntity);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    public void m_6810_(BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.m_60713_(blockState2.m_60734_())) {
            BlockEntity blockEntity;
            BlockEntity blockEntity2 = level.m_7702_(blockPos);
            if (blockEntity2 instanceof Container) {
                Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)((Container)blockEntity2));
                level.m_46717_(blockPos, (Block)this);
            }
            if ((blockEntity = level.m_7702_(blockPos)) instanceof AbstractDrawerBlockEntity) {
                AbstractDrawerBlockEntity drawerBlockEntity = (AbstractDrawerBlockEntity)blockEntity;
                CountertopType currentCounterTop = drawerBlockEntity.countertopType;
                if (currentCounterTop.getItem() != this.plankBlock) {
                    Containers.m_18992_((Level)level, (double)((double)blockPos.m_123341_() + 0.5), (double)((double)blockPos.m_123342_() + 0.85), (double)((double)blockPos.m_123343_() + 0.5), (ItemStack)new ItemStack((ItemLike)currentCounterTop.getItem()));
                }
            }
            super.m_6810_(blockState, level, blockPos, blockState2, bl);
        }
    }

    public void m_213897_(@NotNull BlockState blockState, ServerLevel serverLevel, @NotNull BlockPos blockPos, @NotNull RandomSource randomSource) {
        BlockEntity blockEntity = serverLevel.m_7702_(blockPos);
        if (blockEntity instanceof AbstractDrawerBlockEntity) {
            ((AbstractDrawerBlockEntity)blockEntity).recheckOpen();
        }
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }
}

