/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block;

import com.starfish_studios.yaf.block.entity.TableBlockEntity;
import com.starfish_studios.yaf.block.properties.ChangeableBlock;
import com.starfish_studios.yaf.block.properties.Cushionable;
import com.starfish_studios.yaf.registry.YAFTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TableBlock
extends HalfTransparentBlock
implements SimpleWaterloggedBlock,
ChangeableBlock,
EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty UPDATE = BooleanProperty.m_61465_((String)"update");
    public static final BooleanProperty SHORT = BooleanProperty.m_61465_((String)"short");
    protected static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape TOP_CLOTHED = Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape LEG_1 = Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)4.0);
    protected static final VoxelShape LEG_2 = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)13.0, (double)15.0);
    protected static final VoxelShape LEG_3 = Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)13.0, (double)15.0);
    protected static final VoxelShape LEG_4 = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)13.0, (double)4.0);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{TOP, Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)LEG_1), Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)LEG_2), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2}), Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)LEG_3), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_3}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_3}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_3}), Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)LEG_4), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_3, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_3, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_3, LEG_4}), Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_3, LEG_4})};
    protected static final VoxelShape TOP_SHORT = Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_CLOTHED_SHORT = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape LEG_1_SHORT = Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)4.0);
    protected static final VoxelShape LEG_2_SHORT = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)5.0, (double)15.0);
    protected static final VoxelShape LEG_3_SHORT = Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)5.0, (double)15.0);
    protected static final VoxelShape LEG_4_SHORT = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)5.0, (double)4.0);
    protected static final VoxelShape[] SHAPES_SHORT = new VoxelShape[]{TOP_SHORT, Shapes.m_83110_((VoxelShape)TOP_SHORT, (VoxelShape)LEG_1_SHORT), Shapes.m_83110_((VoxelShape)TOP_SHORT, (VoxelShape)LEG_2_SHORT), Shapes.m_83124_((VoxelShape)TOP_SHORT, (VoxelShape[])new VoxelShape[]{LEG_1_SHORT, LEG_2_SHORT}), Shapes.m_83110_((VoxelShape)TOP_SHORT, (VoxelShape)LEG_3_SHORT), Shapes.m_83124_((VoxelShape)TOP_SHORT, (VoxelShape[])new VoxelShape[]{LEG_1_SHORT, LEG_3_SHORT}), Shapes.m_83124_((VoxelShape)TOP_SHORT, (VoxelShape[])new VoxelShape[]{LEG_2_SHORT, LEG_3_SHORT}), Shapes.m_83124_((VoxelShape)TOP_SHORT, (VoxelShape[])new VoxelShape[]{LEG_1_SHORT, LEG_2_SHORT, LEG_3_SHORT}), Shapes.m_83110_((VoxelShape)TOP_SHORT, (VoxelShape)LEG_4_SHORT), Shapes.m_83124_((VoxelShape)TOP_SHORT, (VoxelShape[])new VoxelShape[]{LEG_1_SHORT, LEG_4_SHORT}), Shapes.m_83124_((VoxelShape)TOP_SHORT, (VoxelShape[])new VoxelShape[]{LEG_2_SHORT, LEG_4_SHORT}), Shapes.m_83124_((VoxelShape)TOP_SHORT, (VoxelShape[])new VoxelShape[]{LEG_1_SHORT, LEG_2_SHORT, LEG_4_SHORT}), Shapes.m_83110_((VoxelShape)TOP_SHORT, (VoxelShape)LEG_3_SHORT), Shapes.m_83124_((VoxelShape)TOP_SHORT, (VoxelShape[])new VoxelShape[]{LEG_1_SHORT, LEG_3_SHORT}), Shapes.m_83124_((VoxelShape)TOP_SHORT, (VoxelShape[])new VoxelShape[]{LEG_2_SHORT, LEG_3_SHORT}), Shapes.m_83124_((VoxelShape)TOP_SHORT, (VoxelShape[])new VoxelShape[]{LEG_1_SHORT, LEG_2_SHORT, LEG_3_SHORT, LEG_4_SHORT})};

    public TableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SHORT, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TableBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.tryChangeBlock((Property<?>)SHORT, state, (LevelAccessor)level, pos, player, hand)) {
            return InteractionResult.SUCCESS;
        }
        if (hand == InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Override
    public boolean tryChangeBlock(Property<?> property, BlockState state, LevelAccessor level, BlockPos pos, Player player, InteractionHand hand) {
        BlockEntity blockEntity;
        boolean success = ChangeableBlock.super.tryChangeBlock(property, state, level, pos, player, hand);
        if (success && (blockEntity = level.m_7702_(pos)) instanceof TableBlockEntity) {
            TableBlockEntity entity = (TableBlockEntity)blockEntity;
            entity.setShort((Boolean)state.m_61143_((Property)SHORT) == false);
        }
        return success;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int shape = 0;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TableBlockEntity) {
            TableBlockEntity tableBlockEntity = (TableBlockEntity)blockEntity;
            if (tableBlockEntity.hasLeg(1)) {
                ++shape;
            }
            if (tableBlockEntity.hasLeg(2)) {
                shape += 2;
            }
            if (tableBlockEntity.hasLeg(3)) {
                shape += 4;
            }
            if (tableBlockEntity.hasLeg(4)) {
                shape += 8;
            }
        }
        return (Boolean)state.m_61143_((Property)SHORT) != false ? SHAPES_SHORT[shape] : SHAPES[shape];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        return this.getConnections(state, (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return this.getConnections(state, level, currentPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, UPDATE, WATERLOGGED, SHORT});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NONE: 
            case CLOCKWISE_90: 
            case CLOCKWISE_180: 
            case COUNTERCLOCKWISE_90: 
        }
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState getConnections(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean n = this.validConnection(state, level.m_8055_(pos.m_122012_()));
        boolean e = this.validConnection(state, level.m_8055_(pos.m_122029_()));
        boolean s = this.validConnection(state, level.m_8055_(pos.m_122019_()));
        boolean w = this.validConnection(state, level.m_8055_(pos.m_122024_()));
        boolean leg1 = !n && !e || n && e && !this.validConnection(state, level.m_8055_(pos.m_122012_().m_122029_()));
        boolean leg2 = !e && !s || e && s && !this.validConnection(state, level.m_8055_(pos.m_122019_().m_122029_()));
        boolean leg3 = !s && !w || s && w && !this.validConnection(state, level.m_8055_(pos.m_122019_().m_122024_()));
        boolean leg4 = !n && !w || n && w && !this.validConnection(state, level.m_8055_(pos.m_122012_().m_122024_()));
        boolean update = ((n ? 1 : 0) + (e ? 1 : 0) + (s ? 1 : 0) + (w ? 1 : 0)) % 2 == 0;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TableBlockEntity) {
            TableBlockEntity tableBlockEntity = (TableBlockEntity)blockEntity;
            tableBlockEntity.setLeg(1, leg1);
            tableBlockEntity.setLeg(2, leg2);
            tableBlockEntity.setLeg(3, leg3);
            tableBlockEntity.setLeg(4, leg4);
        }
        return (BlockState)state.m_61124_((Property)UPDATE, (Comparable)Boolean.valueOf(update));
    }

    public boolean validConnection(BlockState thisState, BlockState state) {
        if (state.m_61138_((Property)SHORT)) {
            return (Boolean)state.m_61143_((Property)SHORT) != false && (Boolean)thisState.m_61143_((Property)SHORT) != false || (Boolean)state.m_61143_((Property)SHORT) == false && (Boolean)thisState.m_61143_((Property)SHORT) == false;
        }
        return state.m_204336_(YAFTags.BlockTags.TABLES_CONNECTABLE);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Cushionable) {
            Cushionable cushionable = (Cushionable)blockEntity;
            cushionable.dropCarpet(level, pos);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }
}

