/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block.entity;

import com.mojang.datafixers.util.Pair;
import com.starfish_studios.yaf.block.CabinetBlock;
import com.starfish_studios.yaf.block.DrawerBlock;
import com.starfish_studios.yaf.block.entity.CabinetBlockEntity;
import com.starfish_studios.yaf.block.properties.CountertopType;
import com.starfish_studios.yaf.inventory.DrawerMenu;
import com.starfish_studios.yaf.registry.YAFSoundEvents;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDrawerBlockEntity
extends RandomizableContainerBlockEntity
implements MenuProvider {
    private static final SoundEvent SOUND_OPEN = (SoundEvent)YAFSoundEvents.DRAWER_OPEN.get();
    private static final SoundEvent SOUND_CLOSE = (SoundEvent)YAFSoundEvents.DRAWER_CLOSE.get();
    public CountertopType countertopType;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)10, (Object)ItemStack.f_41583_);
    public ContainerOpenersCounter openersCounter;

    public AbstractDrawerBlockEntity(BlockEntityType<?> be, BlockPos blockPos, BlockState blockState) {
        super(be, blockPos, blockState);
        this.countertopType = CountertopType.getFromState(blockState);
        this.openersCounter = new ContainerOpenersCounter(){

            protected void m_142292_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
                AbstractDrawerBlockEntity.this.playSound(blockState, SOUND_OPEN);
            }

            protected void m_142289_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
                AbstractDrawerBlockEntity.this.playSound(blockState, SOUND_CLOSE);
            }

            protected void m_142148_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, int i, int j) {
            }

            protected boolean m_142718_(@NotNull Player player) {
                if (player.f_36096_ instanceof DrawerMenu) {
                    Container container = ((DrawerMenu)player.f_36096_).getContainer();
                    return container == AbstractDrawerBlockEntity.this;
                }
                return false;
            }
        };
    }

    protected void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
        if (this.countertopType != null) {
            compoundTag.m_128359_("CountertopType", this.countertopType.m_7912_());
        }
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        if (compoundTag.m_128441_("CountertopType")) {
            String countertopName = compoundTag.m_128461_("CountertopType");
            this.countertopType = CountertopType.valueOf(countertopName.toUpperCase());
        }
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.m_58904_() != null) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compoundtag = new CompoundTag();
        if (this.countertopType != null) {
            compoundtag.m_128359_("CountertopType", this.countertopType.m_7912_());
        }
        return compoundtag;
    }

    public int m_6643_() {
        return 10;
    }

    @NotNull
    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(@NotNull NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.drawer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, @NotNull Inventory inventory, Player player) {
        Pair raycastResult = new Pair((Object)0, (Object)Direction.UP);
        assert (this.f_58857_ != null);
        BlockPos blockPos = this.m_58899_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(blockPos);
        HitResult hitResult = player.m_19907_(10.0, 1.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            Vec3 localHitPos = blockHitResult.m_82450_().m_82546_(Vec3.m_82512_((Vec3i)blockHitResult.m_82425_()));
            boolean isCabinet = this.m_58900_().m_60734_() instanceof CabinetBlock;
            int relativePos = this.getRelativeDrawerPos(blockHitResult.m_82434_(), localHitPos, isCabinet);
            raycastResult = new Pair((Object)relativePos, (Object)blockHitResult.m_82434_());
        }
        if (raycastResult.getSecond() == this.m_58900_().m_61143_((Property)DrawerBlock.FACING) && blockEntity instanceof AbstractDrawerBlockEntity) {
            AbstractDrawerBlockEntity abstractDrawerBlockEntity = (AbstractDrawerBlockEntity)blockEntity;
            if (abstractDrawerBlockEntity instanceof CabinetBlockEntity) {
                if ((Integer)raycastResult.getFirst() > 0) {
                    abstractDrawerBlockEntity.m_58638_((Component)Component.m_237115_((String)"container.cabinet_right"));
                } else {
                    abstractDrawerBlockEntity.m_58638_((Component)Component.m_237115_((String)"container.cabinet_left"));
                }
            } else if ((Integer)raycastResult.getFirst() > 7) {
                abstractDrawerBlockEntity.m_58638_((Component)Component.m_237115_((String)"container.drawer_top"));
            } else {
                abstractDrawerBlockEntity.m_58638_((Component)Component.m_237115_((String)"container.drawer_bottom"));
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.openScreen(abstractDrawerBlockEntity, serverPlayer, (Pair<Integer, Direction>)raycastResult);
            }
        }
        return null;
    }

    public void openMenuOnServer(ServerPlayer serverPlayer, BlockHitResult blockHitResult) {
        Pair raycastResult = new Pair((Object)0, (Object)Direction.UP);
        if (blockHitResult != null) {
            Vec3 localHitPos = blockHitResult.m_82450_().m_82546_(Vec3.m_82512_((Vec3i)blockHitResult.m_82425_()));
            boolean isCabinet = this.m_58900_().m_60734_() instanceof CabinetBlock;
            int relativePos = this.getRelativeDrawerPos(blockHitResult.m_82434_(), localHitPos, isCabinet);
            raycastResult = new Pair((Object)relativePos, (Object)blockHitResult.m_82434_());
        }
        if (raycastResult.getSecond() == this.m_58900_().m_61143_((Property)DrawerBlock.FACING)) {
            this.openScreen(this, serverPlayer, (Pair<Integer, Direction>)raycastResult);
        }
    }

    private void openScreen(final AbstractDrawerBlockEntity blockEntity, ServerPlayer player, final Pair<Integer, Direction> raycastResult) {
        MenuRegistry.openExtendedMenu((ServerPlayer)player, (ExtendedMenuProvider)new ExtendedMenuProvider(){

            public void saveExtraData(FriendlyByteBuf buf) {
            }

            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                int drawerIndex = blockEntity instanceof CabinetBlockEntity ? ((Integer)raycastResult.getFirst() > 0 ? 5 : 0) : ((Integer)raycastResult.getFirst() < 7 ? 0 : 5);
                return new DrawerMenu(id, inventory, (Container)blockEntity, drawerIndex);
            }

            public Component m_5446_() {
                return blockEntity.m_5446_();
            }
        });
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int i, @NotNull Inventory inventory) {
        return new DrawerMenu(i, inventory, (Container)this, 0);
    }

    public int getRelativeDrawerPos(Direction direction, Vec3 localHitPos, boolean isCabinet) {
        if (isCabinet) {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)DrawerBlock.FACING);
            double dot = AbstractDrawerBlockEntity.getDot(localHitPos, facing);
            return (int)Math.floor(dot * 16.0);
        }
        return -(switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST -> (int)Math.floor(1.0 - (localHitPos.m_7098_() + 0.5) * 16.0);
            case Direction.UP -> (int)Math.floor((localHitPos.m_7094_() + 0.5) * 16.0);
            case Direction.DOWN -> (int)Math.floor(1.0 - (localHitPos.m_7094_() + 0.5) * 16.0);
        });
    }

    private static double getDot(Vec3 localHitPos, Direction facing) {
        int leftX = 0;
        int leftZ = 0;
        switch (facing) {
            case NORTH: {
                leftX = -1;
                break;
            }
            case SOUTH: {
                leftX = 1;
                break;
            }
            case EAST: {
                leftZ = -1;
                break;
            }
            case WEST: {
                leftZ = 1;
                break;
            }
        }
        return localHitPos.m_7096_() * (double)leftX + localHitPos.m_7094_() * (double)leftZ;
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
        }
    }

    void playSound(BlockState blockState, SoundEvent soundEvent) {
        if (blockState.m_60734_() instanceof CabinetBlock) {
            double d = (double)this.f_58858_.m_123341_() + 0.5;
            double e = (double)this.f_58858_.m_123342_() + 0.5;
            double f = (double)this.f_58858_.m_123343_() + 0.5;
            assert (this.f_58857_ != null);
            this.f_58857_.m_6263_(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
        } else {
            Vec3i vec3i = ((Direction)blockState.m_61143_((Property)DrawerBlock.FACING)).m_122436_();
            double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
            double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
            double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
            assert (this.f_58857_ != null);
            this.f_58857_.m_6263_(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }
}

