/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block.entity;

import com.starfish_studios.yaf.block.CabinetBlock;
import com.starfish_studios.yaf.block.entity.AbstractDrawerBlockEntity;
import com.starfish_studios.yaf.inventory.DrawerMenu;
import com.starfish_studios.yaf.registry.YAFBlockEntities;
import com.starfish_studios.yaf.registry.YAFSoundEvents;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CabinetBlockEntity
extends AbstractDrawerBlockEntity {
    private static final SoundEvent SOUND_OPEN = (SoundEvent)YAFSoundEvents.CABINET_OPEN.get();
    private static final SoundEvent SOUND_CLOSE = (SoundEvent)YAFSoundEvents.CABINET_CLOSE.get();

    public CabinetBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)YAFBlockEntities.CABINET.get(), blockPos, blockState);
        this.openersCounter = new ContainerOpenersCounter(){

            protected void m_142292_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
                CabinetBlockEntity.this.playSound(blockState, SOUND_OPEN);
            }

            protected void m_142289_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
                CabinetBlockEntity.this.playSound(blockState, SOUND_CLOSE);
            }

            protected void m_142148_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, int i, int j) {
            }

            protected boolean m_142718_(@NotNull Player player) {
                if (player.f_36096_ instanceof DrawerMenu) {
                    Container container = ((DrawerMenu)player.f_36096_).getContainer();
                    return container == CabinetBlockEntity.this;
                }
                return false;
            }
        };
    }

    void updateLeftDoor(BlockState state, boolean open) {
        assert (this.f_58857_ != null);
        if (state.m_61138_((Property)CabinetBlock.LEFT_OPEN)) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)CabinetBlock.LEFT_OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    void updateRightDoor(BlockState state, boolean open) {
        assert (this.f_58857_ != null);
        if (state.m_61138_((Property)CabinetBlock.RIGHT_OPEN)) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)CabinetBlock.RIGHT_OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    public void m_5856_(@NotNull Player player) {
        HitResult hitResult = player.m_19907_(10.0, 1.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            Vec3 localHitPos = blockHitResult.m_82450_().m_82546_(Vec3.m_82512_((Vec3i)blockHitResult.m_82425_()));
            int relativePos = this.getRelativeDrawerPos(blockHitResult.m_82434_(), localHitPos, true);
            if (relativePos > 0) {
                this.updateRightDoor(this.m_58900_(), true);
            } else {
                this.updateLeftDoor(this.m_58900_(), true);
            }
        }
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(@NotNull Player player) {
        HitResult hitResult = player.m_19907_(10.0, 1.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            Vec3 localHitPos = blockHitResult.m_82450_().m_82546_(Vec3.m_82512_((Vec3i)blockHitResult.m_82425_()));
            int relativePos = this.getRelativeDrawerPos(blockHitResult.m_82434_(), localHitPos, true);
            if (relativePos > 0) {
                this.updateRightDoor(this.m_58900_(), false);
            } else {
                this.updateLeftDoor(this.m_58900_(), false);
            }
        }
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
        }
    }
}

