/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block.entity;

import com.starfish_studios.yaf.registry.YAFBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FanBlockEntity
extends BlockEntity {
    private static final int MAX_DISTANCE = 8;
    private static final double MAX_FORCE = 0.25;
    private static final double MIN_FORCE = 0.05;
    private static final float MAX_SPEED = 40.0f;
    private static final float ACCELERATION = 0.5f;
    private static final float DECELERATION = 0.3f;
    private float rotationSpeed = 0.0f;
    private float currentRotation = 0.0f;
    public boolean fanOn = false;

    public FanBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)YAFBlockEntities.FAN.get(), pos, blockState);
    }

    public void commonTick(Level level, BlockState state) {
        if (level.m_5776_()) {
            this.rotationSpeed = this.fanOn ? Math.min(this.rotationSpeed + 0.5f, 40.0f) : Math.max(this.rotationSpeed - 0.3f, 0.0f);
            this.currentRotation = (this.currentRotation + this.rotationSpeed) % 360.0f;
        }
        if (!this.fanOn) {
            return;
        }
        BlockPos pos = this.m_58899_();
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        if (direction == Direction.DOWN) {
            return;
        }
        Vec3 fanPos = Vec3.m_82512_((Vec3i)pos);
        Vec3i pushDirection = direction.m_122436_();
        if (level.m_5776_() && level.m_46467_() % 10L == 0L) {
            Vec3 spawnPos;
            Vec3 directionVec = new Vec3((double)pushDirection.m_123341_(), (double)pushDirection.m_123342_(), (double)pushDirection.m_123343_());
            Vec3 baseSpawnPos = fanPos.m_82549_(directionVec.m_82490_(0.5));
            if (direction == Direction.UP) {
                double offsetX = (level.f_46441_.m_188500_() - 0.5) * 2.0;
                double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 2.0;
                spawnPos = baseSpawnPos.m_82520_(offsetX, 0.0, offsetZ);
            } else {
                Vec3 up = new Vec3(0.0, 1.0, 0.0);
                Vec3 side = directionVec.m_82537_(up).m_82541_();
                double offsetSide = (level.f_46441_.m_188500_() - 0.5) * 2.0;
                double offsetVertical = (level.f_46441_.m_188500_() - 0.5) * 2.0;
                spawnPos = baseSpawnPos.m_82549_(side.m_82490_(offsetSide)).m_82520_(0.0, offsetVertical, 0.0);
            }
            Vec3 velocity = directionVec.m_82490_(0.25);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
        AABB affectedArea = new AABB(pos.m_5484_(direction, 1)).m_82400_(1.05).m_82363_((double)(pushDirection.m_123341_() * 8), (double)(pushDirection.m_123342_() * 8), (double)(pushDirection.m_123343_() * 8));
        List<Entity> entities = level.m_45933_(null, affectedArea).stream().filter(it -> {
            Player player;
            return !(it instanceof Player && (player = (Player)it).m_7500_() && player.m_150110_().f_35935_);
        }).toList();
        double multiplier = 1.0;
        if (direction == Direction.UP) {
            multiplier = 2.0;
        }
        for (Entity entity : entities) {
            double distance = entity.m_20182_().m_82554_(fanPos);
            double force = Mth.m_14139_((double)(distance / 8.0), (double)0.25, (double)0.05);
            Vec3 currentMotion = entity.m_20184_();
            Vec3 pushVelocity = new Vec3((double)pushDirection.m_123341_() * (force *= multiplier), (double)pushDirection.m_123342_() * force, (double)pushDirection.m_123343_() * force);
            Vec3 newMotion = currentMotion.m_82549_(pushVelocity.m_82546_(currentMotion)).m_82490_(0.2);
            entity.m_20256_(currentMotion.m_82549_(newMotion));
        }
    }

    public float getRotationAngle(float partialTick) {
        return (this.currentRotation + this.rotationSpeed * partialTick) % 360.0f;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("On", this.fanOn);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fanOn = tag.m_128471_("On");
    }
}

