/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block.entity;

import com.starfish_studios.yaf.block.MailboxBlock;
import com.starfish_studios.yaf.block.properties.FlagStatus;
import com.starfish_studios.yaf.inventory.MailboxMenu;
import com.starfish_studios.yaf.registry.YAFBlockEntities;
import com.starfish_studios.yaf.registry.YAFSoundEvents;
import com.starfish_studios.yaf.world.YAFSavedData;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MailboxBlockEntity
extends BlockEntity
implements Container,
Nameable {
    public boolean lockTarget = false;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos blockPos, BlockState blockState) {
            MailboxBlockEntity.this.playSound(blockState, (SoundEvent)YAFSoundEvents.MAILBOX_OPEN.get());
            MailboxBlockEntity.this.updateBlockState(blockState, true);
        }

        protected void m_142289_(Level level, BlockPos blockPos, BlockState blockState) {
            MailboxBlockEntity.this.playSound(blockState, (SoundEvent)YAFSoundEvents.MAILBOX_CLOSE.get());
            MailboxBlockEntity.this.updateBlockState(blockState, false);
        }

        protected void m_142148_(Level level, BlockPos blockPos, BlockState blockState, int i, int j) {
        }

        protected boolean m_142718_(Player player) {
            if (player.f_36096_ instanceof MailboxMenu) {
                Container container = ((MailboxMenu)player.f_36096_).getContainer();
                return container == MailboxBlockEntity.this;
            }
            return false;
        }
    };
    public String targetString = "";
    private int sendDelay = 40;
    @Nullable
    private Component name;
    public static ResourceLocation packetChannel = new ResourceLocation("yaf", "sync_mailbox_fail");
    public static ResourceLocation packetChannel2 = new ResourceLocation("yaf", "sync_mailbox_text_reset");
    public boolean failedToSend = false;

    public MailboxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)YAFBlockEntities.MAILBOX.get(), blockPos, blockState);
    }

    public Component getMailboxName() {
        return this.m_5446_();
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
        if (!this.targetString.isEmpty()) {
            compoundTag.m_128359_("Target", this.targetString);
        }
        compoundTag.m_128405_("SendDelay", this.sendDelay);
        if (this.name != null) {
            compoundTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
        compoundTag.m_128379_("FailedToSend", this.failedToSend);
        compoundTag.m_128379_("LockTarget", this.lockTarget);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        if (compoundTag.m_128441_("Target")) {
            this.targetString = compoundTag.m_128461_("Target");
        }
        this.sendDelay = compoundTag.m_128451_("SendDelay");
        if (compoundTag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)compoundTag.m_128461_("CustomName"));
        }
        this.failedToSend = compoundTag.m_128471_("FailedToSend");
        this.lockTarget = compoundTag.m_128471_("LockTarget");
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41613_() <= stack1.m_41741_() && ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }

    private void serverTick() {
        boolean validFlagState;
        boolean bl = validFlagState = this.m_58900_().m_61143_(MailboxBlock.FLAG_STATUS) == FlagStatus.UP;
        if (validFlagState && !this.items.isEmpty() && !this.targetString.isEmpty()) {
            MailboxBlockEntity targetMailbox = this.getTargetMailbox();
            if (targetMailbox != null) {
                if (this.sendDelay > 0) {
                    --this.sendDelay;
                } else {
                    this.sendDelay = 40;
                    if (this.sendToMailboxItems(targetMailbox)) {
                        this.failedToSend = false;
                        this.sendMessageState(this.failedToSend);
                        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(MailboxBlock.FLAG_STATUS, (Comparable)((Object)FlagStatus.DOWN)), 3);
                        if (!this.lockTarget) {
                            this.targetString = "";
                            Level level = this.f_58857_;
                            if (level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                List list = serverLevel.m_7726_().f_8325_.m_183262_(new ChunkPos(this.m_58899_()), false);
                                for (ServerPlayer serverPlayer : list) {
                                    FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                                    buf.m_130064_(this.m_58899_());
                                    NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)packetChannel2, (FriendlyByteBuf)buf);
                                }
                            }
                            this.m_6596_();
                        }
                    } else {
                        this.sendMessageState(this.failedToSend);
                    }
                    this.m_6596_();
                }
            } else {
                this.sendMessageState(this.failedToSend);
            }
        }
    }

    private void sendMessageState(boolean fail) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List list = serverLevel.m_7726_().f_8325_.m_183262_(new ChunkPos(this.m_58899_()), false);
            for (ServerPlayer serverPlayer : list) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_130064_(this.m_58899_());
                buf.writeBoolean(fail);
                NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)packetChannel, (FriendlyByteBuf)buf);
            }
        }
    }

    private MailboxBlockEntity getTargetMailbox() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return null;
        }
        GlobalPos globalPos = this.resolveBlockPos(this.targetString);
        if (globalPos == null) {
            return null;
        }
        MinecraftServer server = this.f_58857_.m_7654_();
        if (server == null) {
            return null;
        }
        ServerLevel dimLevel = server.m_129880_(globalPos.m_122640_());
        if (dimLevel == null || dimLevel.f_46443_) {
            return null;
        }
        BlockEntity be = dimLevel.m_7702_(globalPos.m_122646_());
        if (be instanceof MailboxBlockEntity) {
            return (MailboxBlockEntity)be;
        }
        return null;
    }

    private boolean sendToMailboxItems(MailboxBlockEntity targetMailbox) {
        boolean validTargetFlag;
        boolean validFlagState = this.m_58900_().m_61143_(MailboxBlock.FLAG_STATUS) == FlagStatus.UP;
        boolean bl = validTargetFlag = targetMailbox.m_58900_().m_61143_(MailboxBlock.FLAG_STATUS) == FlagStatus.DOWN;
        if (!validFlagState || !validTargetFlag) {
            return false;
        }
        boolean sentMail = false;
        block0: for (int o = 0; o < this.items.size(); ++o) {
            int i;
            ItemStack toSendStack = ((ItemStack)this.items.get(o)).m_41777_();
            if (toSendStack.m_41619_()) continue;
            toSendStack.m_41784_().m_128359_("mailboxTooltip", "From: " + this.getMailboxName().getString());
            toSendStack.m_41784_().m_128405_("mailboxTooltipTimer", -1);
            boolean merged = false;
            for (i = 0; i < targetMailbox.items.size(); ++i) {
                ItemStack targetStack = (ItemStack)targetMailbox.items.get(i);
                if (targetStack.m_41619_() || !MailboxBlockEntity.canMergeItems(targetStack, toSendStack)) continue;
                int spaceAvailable = targetStack.m_41741_() - targetStack.m_41613_();
                int transferAmount = Math.min(toSendStack.m_41613_(), spaceAvailable);
                if (transferAmount <= 0) continue;
                targetStack.m_41769_(transferAmount);
                targetStack.m_41784_().m_128359_("mailboxTooltip", "From: " + this.getMailboxName().getString());
                targetStack.m_41784_().m_128405_("mailboxTooltipTimer", -1);
                toSendStack.m_41774_(transferAmount);
                sentMail = true;
                if (!toSendStack.m_41619_()) continue;
                this.items.set(o, (Object)ItemStack.f_41583_);
                merged = true;
                break;
            }
            if (merged) continue;
            for (i = 0; i < targetMailbox.items.size(); ++i) {
                if (!((ItemStack)targetMailbox.items.get(i)).m_41619_()) continue;
                targetMailbox.items.set(i, (Object)toSendStack);
                this.items.set(o, (Object)ItemStack.f_41583_);
                sentMail = true;
                continue block0;
            }
        }
        return sentMail;
    }

    private GlobalPos resolveBlockPos(String name) {
        List<Function<String, GlobalPos>> resolvers = List.of(this::checkCoordinates, this::checkPlayerName, this::checkMailboxName);
        for (Function<String, GlobalPos> resolver : resolvers) {
            GlobalPos blockPos = resolver.apply(name);
            if (blockPos == null) continue;
            return blockPos;
        }
        return null;
    }

    private GlobalPos checkMailboxName(String name) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            YAFSavedData data = YAFSavedData.getMailboxes(serverLevel);
            return data.mailboxes.stream().filter(mailbox -> mailbox.name().equals(name)).map(YAFSavedData.MailboxData::globalPos).findFirst().orElse(null);
        }
        return null;
    }

    private GlobalPos checkPlayerName(String name) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            YAFSavedData data = YAFSavedData.getMailboxes(serverLevel);
            return data.mailboxes.stream().filter(mailbox -> mailbox.playerName().equals(name)).map(YAFSavedData.MailboxData::globalPos).findFirst().orElse(null);
        }
        return null;
    }

    private GlobalPos checkCoordinates(String name) {
        if (name.matches("-?\\d+ -?\\d+ -?\\d+")) {
            String[] coords = name.split(" ");
            if (coords.length == 3) {
                try {
                    int x = Integer.parseInt(coords[0]);
                    int y = Integer.parseInt(coords[1]);
                    int z = Integer.parseInt(coords[2]);
                    assert (this.f_58857_ != null);
                    return GlobalPos.m_122643_((ResourceKey)this.f_58857_.m_46472_(), (BlockPos)new BlockPos(x, y, z));
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid coordinate format: " + name);
                }
            } else {
                System.out.println("Coordinate name format is invalid: " + name);
            }
        }
        return null;
    }

    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.mailbox");
    }

    public int m_6643_() {
        return 5;
    }

    public boolean m_7983_() {
        return this.items.isEmpty();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_5856_(@NotNull Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(@NotNull Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
        }
    }

    void updateBlockState(BlockState blockState, boolean bl) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)blockState.m_61124_((Property)MailboxBlock.OPEN, (Comparable)Boolean.valueOf(bl)), 3);
    }

    void playSound(BlockState blockState, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)blockState.m_61143_((Property)MailboxBlock.FACING)).m_122436_();
        double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        assert (this.f_58857_ != null);
        this.f_58857_.m_6263_(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public static void sendItemsTick(Level level, BlockPos pos, BlockState state, MailboxBlockEntity mailboxBlockEntity) {
        if (!level.f_46443_) {
            mailboxBlockEntity.serverTick();
        }
    }

    public void m_6211_() {
        this.items.clear();
    }

    @NotNull
    public Component m_7755_() {
        assert (this.name != null);
        return this.name;
    }

    public void setCustomName(Component translatable) {
        this.name = translatable;
    }
}

