/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.starfish_studios.yaf.block.entity.ChairBlockEntity;
import com.starfish_studios.yaf.block.properties.ColorList;
import com.starfish_studios.yaf.client.model.ChairBlockEntityModel;
import com.starfish_studios.yaf.client.model.ChairCushionModel;
import java.util.Locale;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ChairBlockEntityRenderer
implements BlockEntityRenderer<ChairBlockEntity> {
    private final ChairBlockEntityModel model;
    private final ChairCushionModel cloth;

    public ChairBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new ChairBlockEntityModel(context.m_173582_(ChairBlockEntityModel.LAYER_LOCATION));
        this.cloth = new ChairCushionModel(context.m_173582_(ChairCushionModel.LAYER_LOCATION));
    }

    public void render(ChairBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(blockEntity)));
        this.model.back.f_104207_ = blockEntity.hasBack();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f + ((Direction)blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_()));
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (blockEntity.getColor() != ColorList.EMPTY) {
            VertexConsumer clothConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getClothTextureLocation(blockEntity)));
            this.cloth.m_7695_(poseStack, clothConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }

    private ResourceLocation getTextureLocation(ChairBlockEntity blockEntity) {
        Block state = blockEntity.m_58900_().m_60734_();
        String name = BuiltInRegistries.f_256975_.m_7981_((Object)state).m_135815_();
        String type = blockEntity.getChairType().id;
        return new ResourceLocation("yaf", "textures/entity/chair/" + name + type + ".png");
    }

    private ResourceLocation getClothTextureLocation(ChairBlockEntity blockEntity) {
        String name = blockEntity.getColor().m_7912_().toLowerCase(Locale.ROOT);
        return new ResourceLocation("yaf", "textures/entity/chair/" + name + "_cushion.png");
    }
}

