/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.starfish_studios.yaf.block.FlowerBasketBlock;
import com.starfish_studios.yaf.block.entity.FlowerBasketBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlowerBasketRenderer
implements BlockEntityRenderer<FlowerBasketBlockEntity> {
    private final BlockRenderDispatcher blockRenderer;

    public FlowerBasketRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = context.m_173584_();
    }

    public void render(FlowerBasketBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState state = blockEntity.m_58900_();
        Direction facing = ((Direction)state.m_61143_((Property)FlowerBasketBlock.FACING)).m_122424_();
        float rotation = -facing.m_122435_();
        AttachFace attachFace = (AttachFace)state.m_61143_(FlowerBasketBlock.FACE);
        poseStack.m_85836_();
        poseStack.m_85841_(0.7f, 0.7f, 0.7f);
        poseStack.m_252880_(0.0f, 0.4f, 0.0f);
        if (attachFace == AttachFace.WALL) {
            for (int i = 0; i < 2; ++i) {
                BlockState lower;
                Item item = blockEntity.getItemFromSlot(i);
                if (item == Items.f_41852_) continue;
                Block block = ((BlockItem)item).m_40614_();
                BlockState upper = null;
                if (block instanceof DoublePlantBlock) {
                    lower = (BlockState)block.m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER);
                    upper = (BlockState)block.m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
                } else {
                    lower = block.m_49966_();
                }
                poseStack.m_85836_();
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
                poseStack.m_252880_(0.6f - 0.8f * (float)i, 0.001f * (float)i, 0.2f);
                poseStack.m_252880_(0.0f, 0.3f, 0.4f);
                switch ((Direction)state.m_61143_((Property)FlowerBasketBlock.FACING)) {
                    case EAST: {
                        poseStack.m_252880_(0.0f, 0.0f, -1.4f);
                        break;
                    }
                    case WEST: {
                        poseStack.m_252880_(-1.4f, 0.0f, 0.0f);
                        break;
                    }
                    case SOUTH: {
                        poseStack.m_252880_(-1.4f, 0.0f, -1.4f);
                        break;
                    }
                }
                this.blockRenderer.m_110912_(lower, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
                if (upper != null) {
                    poseStack.m_252880_(0.0f, 1.0f, 0.0f);
                    this.blockRenderer.m_110912_(upper, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
                }
                poseStack.m_85849_();
            }
        } else {
            Item item;
            if (attachFace == AttachFace.CEILING) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(0.1f));
            }
            if ((item = blockEntity.getItemFromSlot(0)) != Items.f_41852_) {
                BlockState lower;
                Block block = ((BlockItem)item).m_40614_();
                BlockState upper = null;
                if (block instanceof DoublePlantBlock) {
                    lower = (BlockState)block.m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER);
                    upper = (BlockState)block.m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
                } else {
                    lower = block.m_49966_();
                }
                Direction basketFacing = (Direction)state.m_61143_((Property)FlowerBasketBlock.FACING);
                float offsetX = 0.25f;
                float offsetZ = 0.25f;
                if (attachFace == AttachFace.FLOOR) {
                    switch (basketFacing) {
                        case NORTH: {
                            offsetZ = 0.2f;
                            break;
                        }
                        case SOUTH: {
                            offsetZ = -1.2f;
                            offsetX = -1.2f;
                            break;
                        }
                        case EAST: {
                            offsetZ = -1.2f;
                            break;
                        }
                        case WEST: {
                            offsetX = -1.2f;
                            offsetZ = 0.2f;
                        }
                    }
                }
                if (attachFace == AttachFace.FLOOR) {
                    poseStack.m_85836_();
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
                    poseStack.m_252880_(offsetX, 0.0f, offsetZ);
                    this.blockRenderer.m_110912_(lower, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
                    if (upper != null) {
                        poseStack.m_252880_(0.0f, 1.0f, 0.0f);
                        this.blockRenderer.m_110912_(upper, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
                    }
                    poseStack.m_85849_();
                } else if (attachFace == AttachFace.CEILING) {
                    poseStack.m_85836_();
                    poseStack.m_252880_(offsetX, 0.0f, offsetZ);
                    this.blockRenderer.m_110912_(lower, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
                    if (upper != null) {
                        poseStack.m_252880_(0.0f, -1.0f, 0.0f);
                        this.blockRenderer.m_110912_(upper, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
                    }
                    poseStack.m_85849_();
                }
            }
        }
        poseStack.m_85849_();
    }
}

