/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.starfish_studios.yaf.YAFConfig;
import com.starfish_studios.yaf.block.ShelfBlock;
import com.starfish_studios.yaf.block.entity.ShelfBlockEntity;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShelfBlockEntityRenderer
implements BlockEntityRenderer<ShelfBlockEntity> {
    private final RandomSource random = RandomSource.m_216327_();

    public ShelfBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ShelfBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction direction = (Direction)blockEntity.m_58900_().m_61143_((Property)ShelfBlock.FACING);
        AttachFace face = (AttachFace)blockEntity.m_58900_().m_61143_(ShelfBlock.FACE);
        boolean shouldCenter = face == AttachFace.FLOOR || face == AttachFace.CEILING;
        float rotation = -direction.m_122435_() + 90.0f;
        NonNullList<ItemStack> items = blockEntity.getItems();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.8, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        for (int j = 0; j < items.size(); ++j) {
            ItemStack stack = (ItemStack)items.get(j);
            if (stack.m_41619_()) continue;
            int seed = Item.m_41393_((Item)stack.m_41720_()) + stack.m_41773_();
            this.random.m_188584_((long)seed);
            int renderCount = this.getAmount(stack.m_41613_());
            for (int i = 0; i < renderCount; ++i) {
                int count;
                float fx = (this.random.m_188501_() * 2.0f - 1.0f) * 0.15f * 0.5f;
                float fy = (this.random.m_188501_() * 2.0f - 1.0f) * 0.15f * 0.5f;
                float fz = (this.random.m_188501_() * 2.0f - 1.0f) * 0.15f * 0.5f;
                poseStack.m_85836_();
                poseStack.m_85837_(shouldCenter ? 0.0 : 0.225, 0.5 * (double)(-(j % 2)), -0.225 + 0.4 * (double)(j / 2));
                poseStack.m_85837_((double)fx, (double)fy + 0.025, (double)fz);
                poseStack.m_85841_(0.375f, 0.375f, 0.375f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                boolean shouldRender = ShelfBlockEntityRenderer.isShouldRender();
                if (shouldRender && i == 0 && (count = stack.m_41613_()) > 1) {
                    poseStack.m_85836_();
                    poseStack.m_85837_(-0.3, 0.0, -0.75);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(-rotation - 90.0f));
                    ShelfBlockEntityRenderer.renderFloatingText(poseStack, bufferSource, String.valueOf(count), 0.03f, packedLight);
                    poseStack.m_85849_();
                }
                if (!YAFConfig.stillItems) {
                    float spinSpeed = 2.0f;
                    float dynamicRotation = ((float)Objects.requireNonNull(blockEntity.m_58904_()).m_46467_() + partialTick) * spinSpeed % 360.0f;
                    poseStack.m_85837_(0.0, Math.sin((double)((float)blockEntity.m_58904_().m_46467_() + partialTick) / 8.0) / 16.0, 0.0);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(dynamicRotation));
                }
                Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.m_58904_(), 0);
                poseStack.m_85849_();
            }
        }
        poseStack.m_85849_();
    }

    private static boolean isShouldRender() {
        boolean shouldRender;
        if (YAFConfig.neverShowShelfNumbers) {
            shouldRender = false;
        } else if (YAFConfig.alwaysShowShelfNumbers) {
            shouldRender = true;
        } else {
            assert (Minecraft.m_91087_().f_91074_ != null);
            shouldRender = Minecraft.m_91087_().f_91074_.m_6144_();
        }
        return shouldRender;
    }

    public static void renderFloatingText(PoseStack poseStack, MultiBufferSource buffer, String text, float scale, int packedLight) {
        Minecraft minecraft = Minecraft.m_91087_();
        Camera camera = minecraft.f_91063_.m_109153_();
        if (camera.m_90593_()) {
            Font font = minecraft.f_91062_;
            float opacity = Minecraft.m_91087_().f_91066_.m_92141_(0.5f);
            int alpha = (int)(opacity * 255.0f) << 24;
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-camera.m_90590_()));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(camera.m_90589_()));
            poseStack.m_85841_(-scale, -scale, scale);
            float h = (float)(-font.m_92895_(text)) / 2.0f;
            font.m_271703_(text, h, 0.0f, 0x20FFFFFF, false, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, alpha, packedLight);
            font.m_271703_(text, h, 0.0f, -1, false, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, packedLight);
            poseStack.m_85849_();
        }
    }

    public int getAmount(int count) {
        if (count > 48) {
            return 5;
        }
        if (count > 32) {
            return 4;
        }
        if (count > 16) {
            return 3;
        }
        if (count > 1) {
            return 2;
        }
        return 1;
    }
}

