/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.events;

import com.starfish_studios.yaf.block.LampBlock;
import com.starfish_studios.yaf.block.entity.TableBlockEntity;
import com.starfish_studios.yaf.block.properties.ColorList;
import dev.architectury.event.EventResult;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class LampInteractions {
    private static final Map<ColorList, Item> SHEAR_MAP = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put(ColorList.WHITE, Items.f_42130_);
        map.put(ColorList.LIGHT_GRAY, Items.f_42138_);
        map.put(ColorList.GRAY, Items.f_42137_);
        map.put(ColorList.BLACK, Items.f_42198_);
        map.put(ColorList.BROWN, Items.f_42142_);
        map.put(ColorList.RED, Items.f_42197_);
        map.put(ColorList.ORANGE, Items.f_42131_);
        map.put(ColorList.YELLOW, Items.f_42134_);
        map.put(ColorList.LIME, Items.f_42135_);
        map.put(ColorList.GREEN, Items.f_42143_);
        map.put(ColorList.CYAN, Items.f_42139_);
        map.put(ColorList.LIGHT_BLUE, Items.f_42133_);
        map.put(ColorList.BLUE, Items.f_42141_);
        map.put(ColorList.PURPLE, Items.f_42140_);
        map.put(ColorList.MAGENTA, Items.f_42132_);
        map.put(ColorList.PINK, Items.f_42136_);
    });

    public static BlockState getBlockstateForDye(Item item, BlockState blockState) {
        return (BlockState)blockState.m_61124_(LampBlock.LAMPSHADE, (Comparable)((Object)LampInteractions.getColorFor(item)));
    }

    public static ColorList getColorFor(Item item) {
        if (item == Items.f_42535_) {
            return ColorList.WHITE;
        }
        if (item == Items.f_42536_) {
            return ColorList.ORANGE;
        }
        if (item == Items.f_42537_) {
            return ColorList.MAGENTA;
        }
        if (item == Items.f_42538_) {
            return ColorList.LIGHT_BLUE;
        }
        if (item == Items.f_42539_) {
            return ColorList.YELLOW;
        }
        if (item == Items.f_42540_) {
            return ColorList.LIME;
        }
        if (item == Items.f_42489_) {
            return ColorList.PINK;
        }
        if (item == Items.f_42490_) {
            return ColorList.GRAY;
        }
        if (item == Items.f_42491_) {
            return ColorList.LIGHT_GRAY;
        }
        if (item == Items.f_42492_) {
            return ColorList.CYAN;
        }
        if (item == Items.f_42493_) {
            return ColorList.PURPLE;
        }
        if (item == Items.f_42494_) {
            return ColorList.BLUE;
        }
        if (item == Items.f_42495_) {
            return ColorList.BROWN;
        }
        if (item == Items.f_42496_) {
            return ColorList.GREEN;
        }
        if (item == Items.f_42497_) {
            return ColorList.RED;
        }
        if (item == Items.f_42498_) {
            return ColorList.BLACK;
        }
        return ColorList.EMPTY;
    }

    public static BlockState getBlockstateForCarpet(Item item, BlockState blockState) {
        return (BlockState)blockState.m_61124_(LampBlock.LAMPSHADE, (Comparable)((Object)LampInteractions.getCarpetFor(item)));
    }

    public static ColorList getCarpetFor(Item item) {
        if (item == Items.f_42130_) {
            return ColorList.WHITE;
        }
        if (item == Items.f_42138_) {
            return ColorList.LIGHT_GRAY;
        }
        if (item == Items.f_42137_) {
            return ColorList.GRAY;
        }
        if (item == Items.f_42198_) {
            return ColorList.BLACK;
        }
        if (item == Items.f_42142_) {
            return ColorList.BROWN;
        }
        if (item == Items.f_42197_) {
            return ColorList.RED;
        }
        if (item == Items.f_42131_) {
            return ColorList.ORANGE;
        }
        if (item == Items.f_42134_) {
            return ColorList.YELLOW;
        }
        if (item == Items.f_42135_) {
            return ColorList.LIME;
        }
        if (item == Items.f_42143_) {
            return ColorList.GREEN;
        }
        if (item == Items.f_42139_) {
            return ColorList.CYAN;
        }
        if (item == Items.f_42133_) {
            return ColorList.LIGHT_BLUE;
        }
        if (item == Items.f_42141_) {
            return ColorList.BLUE;
        }
        if (item == Items.f_42140_) {
            return ColorList.PURPLE;
        }
        if (item == Items.f_42132_) {
            return ColorList.MAGENTA;
        }
        if (item == Items.f_42136_) {
            return ColorList.PINK;
        }
        return ColorList.EMPTY;
    }

    public static EventResult interact(Player player, InteractionHand hand, BlockPos pos, Direction direction) {
        TableBlockEntity tableBlockEntity;
        BlockEntity blockEntity;
        Level level = player.m_9236_();
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (item instanceof ShearsItem && (blockEntity = level.m_7702_(pos)) instanceof TableBlockEntity && (tableBlockEntity = (TableBlockEntity)blockEntity).getColor() != ColorList.EMPTY) {
            ColorList color = tableBlockEntity.getColor();
            Item carpet = SHEAR_MAP.get((Object)color);
            if (carpet != null) {
                tableBlockEntity.setColor(ColorList.EMPTY);
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)carpet, 1)));
                level.m_5594_(null, pos, SoundEvents.f_12344_, player.m_5720_(), 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
                return EventResult.interruptTrue();
            }
        } else if (item instanceof DyeItem && block instanceof LampBlock) {
            ColorList dyeColor;
            ColorList currentColor = (ColorList)((Object)blockState.m_61143_(LampBlock.LAMPSHADE));
            if (currentColor == (dyeColor = LampInteractions.getColorFor(item))) {
                return EventResult.pass();
            }
            if (currentColor != ColorList.EMPTY) {
                BlockState newState = LampInteractions.getBlockstateForDye(item, blockState);
                level.m_46597_(pos, newState);
                DyeColor color = ((DyeItem)item).m_41089_();
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                level.m_5594_(null, pos, SoundEvents.f_144133_, player.m_5720_(), 1.0f, 1.0f);
                for (int j = 0; j < 5; ++j) {
                    double g = level.f_46441_.m_188583_() * 0.2;
                    double h = level.f_46441_.m_188583_() * 0.1;
                    double i = level.f_46441_.m_188583_() * 0.2;
                    DustParticleOptions dustParticleOptions = new DustParticleOptions(Vec3.m_82501_((int)color.m_41071_()).m_252839_(), 1.0f);
                    if (level.f_46443_) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)dustParticleOptions, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5, 1, g, h, i, 0.0);
                }
                return EventResult.interruptTrue();
            }
        }
        return EventResult.pass();
    }
}

