/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.loot.BiomeTagPredicate;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class AquaBiomeModifiers {
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS_DEFERRED = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"aquaculture");

    public record FishSpawnBiomeModifier(List<HolderSet<Biome>> includeBiomes, List<HolderSet<Biome>> excludeBiomes, boolean and, MobSpawnSettings.SpawnerData spawn) implements BiomeModifier
    {
        private static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)new ResourceLocation("aquaculture", "fish_spawn_serializer"), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"aquaculture");

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD) {
                if (biome.m_203616_().noneMatch(BiomeTagPredicate.INVALID_TYPES::contains)) {
                    if (((HolderSet)this.includeBiomes.stream().findAny().get()).m_203614_().findAny().isEmpty() && !this.excludeBiomes.isEmpty()) {
                        for (HolderSet<Biome> exclude : this.excludeBiomes) {
                            if (!exclude.m_203333_(biome)) continue;
                            return;
                        }
                        this.debugOutput(biome, "Exclude only. Valid biome included");
                        builder.getMobSpawnSettings().m_48376_(this.spawn.f_48404_.m_20674_(), this.spawn);
                    } else if (this.and) {
                        for (HolderSet<Biome> include : this.includeBiomes) {
                            if (include.m_203333_(biome)) continue;
                            return;
                        }
                        this.debugOutput(biome, "And Include");
                        builder.getMobSpawnSettings().m_48376_(this.spawn.f_48404_.m_20674_(), this.spawn);
                    } else {
                        for (HolderSet<Biome> exclude : this.excludeBiomes) {
                            if (!exclude.m_203333_(biome)) continue;
                            return;
                        }
                        for (HolderSet<Biome> include : this.includeBiomes) {
                            if (!include.m_203333_(biome)) continue;
                            this.debugOutput(biome, "Normal");
                            builder.getMobSpawnSettings().m_48376_(this.spawn.f_48404_.m_20674_(), this.spawn);
                        }
                    }
                }
            }
        }

        private void debugOutput(Holder<Biome> biomeHolder, String s) {
            if (((Boolean)AquaConfig.BASIC_OPTIONS.debugMode.get()).booleanValue()) {
                Aquaculture.LOG.info("Fish: " + String.valueOf(ForgeRegistries.ENTITY_TYPES.getKey((Object)this.spawn.f_48404_)) + " | " + s + ": " + String.valueOf(((ResourceKey)biomeHolder.m_203543_().get()).m_135782_()));
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)SERIALIZER.get();
        }

        public static Codec<FishSpawnBiomeModifier> makeCodec() {
            return RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.listOf().fieldOf("includeBiomes").forGetter(FishSpawnBiomeModifier::includeBiomes), (App)Biome.f_47432_.listOf().fieldOf("excludeBiomes").forGetter(FishSpawnBiomeModifier::excludeBiomes), (App)Codec.BOOL.fieldOf("and").forGetter(FishSpawnBiomeModifier::and), (App)MobSpawnSettings.SpawnerData.f_48403_.fieldOf("spawn").forGetter(FishSpawnBiomeModifier::spawn)).apply((Applicative)builder, FishSpawnBiomeModifier::new));
        }
    }

    public record MobSpawnBiomeModifier(HolderSet<Biome> includeList, HolderSet<Biome> excludeList, MobSpawnSettings.SpawnerData spawn) implements BiomeModifier
    {
        private static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)new ResourceLocation("aquaculture", "mob_spawn_serializer"), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"aquaculture");

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.includeList.m_203333_(biome) && !this.excludeList.m_203333_(biome)) {
                builder.getMobSpawnSettings().m_48376_(this.spawn.f_48404_.m_20674_(), this.spawn);
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)SERIALIZER.get();
        }

        public static Codec<MobSpawnBiomeModifier> makeCodec() {
            return RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("includeBiomes").forGetter(MobSpawnBiomeModifier::includeList), (App)Biome.f_47432_.fieldOf("excludeBiomes").forGetter(MobSpawnBiomeModifier::excludeList), (App)MobSpawnSettings.SpawnerData.f_48403_.fieldOf("spawn").forGetter(MobSpawnBiomeModifier::spawn)).apply((Applicative)builder, MobSpawnBiomeModifier::new));
        }
    }
}

