/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.elysium_api.impl.use_behavior;

import java.util.Optional;
import net.jadenxgamer.elysium_api.Elysium;
import net.jadenxgamer.elysium_api.api.util.ResourceKeyRegistryHelper;
import net.jadenxgamer.elysium_api.impl.registry.ElysiumRegistries;
import net.jadenxgamer.elysium_api.impl.use_behavior.AfterUseItemEnum;
import net.jadenxgamer.elysium_api.impl.use_behavior.PosEnum;
import net.jadenxgamer.elysium_api.impl.use_behavior.UseBehavior;
import net.jadenxgamer.elysium_api.impl.use_behavior.UseBehaviorTypeEnum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class UseBehaviorImpl {
    public static void init(PlayerInteractEvent.RightClickBlock event) {
        int chanceToFail;
        if (Elysium.registryAccess == null) {
            return;
        }
        Level level = event.getLevel();
        BlockState state = level.m_8055_(event.getPos());
        Player player = event.getEntity();
        ItemStack stack = player.m_21120_(event.getHand());
        Optional<UseBehavior> useBehavior = Elysium.registryAccess.m_175515_(ElysiumRegistries.BLOCK_USE_BEHAVIORS).m_123024_().filter(s -> s.blocks().m_203333_(state.m_222976_()) && s.itemCondition().m_203333_(stack.m_220173_())).findFirst();
        if (level.m_5776_()) {
            return;
        }
        if (useBehavior.isEmpty()) {
            return;
        }
        UseBehavior registry = useBehavior.get();
        BlockPos pos = UseBehaviorImpl.getPosFromCodec(registry.behavior().pos(), registry.behavior().posOffset(), event);
        if (UseBehaviorImpl.placeRelated(registry) && !registry.behavior().canReplace() && !level.m_8055_(pos).m_247087_()) {
            return;
        }
        if (registry.blockstateCondition().isPresent() && !registry.blockstateCondition().get().equals(state)) {
            return;
        }
        if (!player.m_150110_().f_35937_) {
            UseBehaviorImpl.handleItemAfterUse(registry.behavior().afterUseItem(), stack, event);
        }
        if (registry.behavior().sounds().isPresent()) {
            level.m_5594_(null, event.getPos(), registry.behavior().sounds().get().soundEvent(), SoundSource.BLOCKS, registry.behavior().sounds().get().volume(), registry.behavior().sounds().get().pitch());
        }
        if (registry.behavior().particles().isPresent()) {
            UseBehaviorImpl.spawnParticles((ServerLevel)level, pos, registry.behavior().particles().get().particleType(), registry.behavior().particles().get().count(), registry.behavior().particles().get().speed(), registry.behavior().particles().get().xOffset(), registry.behavior().particles().get().yOffset(), registry.behavior().particles().get().zOffset());
        }
        if ((chanceToFail = registry.chanceToFail()) > 0 && level.f_46441_.m_188503_(chanceToFail) != 0) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        switch (registry.behavior().type()) {
            case PLACE: {
                UseBehaviorImpl.placeBlock(level, pos, registry.behavior().block().get(), event);
                break;
            }
            case PLACE_ITSELF: {
                UseBehaviorImpl.placeBlock(level, pos, state, event);
                break;
            }
            case DROP: {
                UseBehaviorImpl.dropStack(level, pos, event.getFace(), registry.behavior().item().get(), registry.behavior().itemCount());
                break;
            }
            case DROP_ITSELF: {
                UseBehaviorImpl.dropStack(level, pos, event.getFace(), ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()), registry.behavior().itemCount());
                break;
            }
            case FEATURE: {
                UseBehaviorImpl.placeFeature(level, pos, registry.behavior().feature().get());
                break;
            }
            case INSERT_STACK: {
                UseBehaviorImpl.insertStack(player, registry.behavior().item().get(), registry.behavior().itemCount());
            }
        }
        if (registry.behavior().breakParticles()) {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    private static void placeBlock(Level level, BlockPos pos, BlockState state, PlayerInteractEvent.RightClickBlock event) {
        if (state != null && state.m_60734_().m_7898_(level.m_8055_(pos), (LevelReader)level, pos)) {
            level.m_7731_(pos, state, 3);
        }
    }

    private static void dropStack(Level level, BlockPos pos, Direction direction, ResourceLocation location, int count) {
        Item item = ResourceKeyRegistryHelper.getItem(location);
        Block.m_152435_((Level)level, (BlockPos)pos, (Direction)direction, (ItemStack)new ItemStack((ItemLike)item, count));
    }

    private static void insertStack(Player player, ResourceLocation location, int count) {
        Item item = ResourceKeyRegistryHelper.getItem(location);
        player.m_150109_().m_36054_(new ItemStack((ItemLike)item, count));
    }

    private static void placeFeature(Level level, BlockPos pos, ResourceLocation location) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ResourceKey featureKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)location);
            serverLevel.m_9598_().m_6632_(Registries.f_256911_).flatMap(registry -> registry.m_203636_(featureKey)).ifPresent(holder -> ((ConfiguredFeature)holder.m_203334_()).m_224953_((WorldGenLevel)serverLevel, serverLevel.m_7726_().m_8481_(), serverLevel.f_46441_, pos));
        }
    }

    private static void handleItemAfterUse(AfterUseItemEnum afterUse, ItemStack stack, PlayerInteractEvent.RightClickBlock event) {
        switch (afterUse) {
            case CONSUME: {
                stack.m_41774_(1);
                break;
            }
            case DAMAGE: {
                stack.m_41622_(1, (LivingEntity)event.getEntity(), p -> p.m_21190_(event.getHand()));
            }
        }
    }

    private static BlockPos getPosFromCodec(PosEnum pos, int offset, PlayerInteractEvent.RightClickBlock event) {
        BlockPos basePos = event.getPos();
        return switch (pos) {
            case PosEnum.ABOVE -> basePos.m_6630_(offset);
            case PosEnum.BELOW -> basePos.m_6625_(offset);
            case PosEnum.NORTH -> basePos.m_122013_(offset);
            case PosEnum.SOUTH -> basePos.m_122020_(offset);
            case PosEnum.EAST -> basePos.m_122030_(offset);
            case PosEnum.WEST -> basePos.m_122025_(offset);
            case PosEnum.RANDOM_HORIZONTAL -> {
                Direction randomDirection = Direction.Plane.HORIZONTAL.m_235690_(event.getLevel().f_46441_);
                yield basePos.m_121945_(randomDirection);
            }
            default -> basePos;
        };
    }

    private static void spawnParticles(ServerLevel level, BlockPos pos, ResourceLocation location, int count, double speed, double xOffset, double yOffset, double zOffset) {
        ParticleType<?> particleType = ResourceKeyRegistryHelper.getParticleType(location);
        if (particleType instanceof SimpleParticleType) {
            SimpleParticleType simple = (SimpleParticleType)particleType;
            level.m_8767_((ParticleOptions)simple, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, count, xOffset, yOffset, zOffset, speed);
        }
    }

    private static boolean placeRelated(UseBehavior registry) {
        UseBehaviorTypeEnum type = registry.behavior().type();
        return type == UseBehaviorTypeEnum.PLACE || type == UseBehaviorTypeEnum.PLACE_ITSELF || type == UseBehaviorTypeEnum.FEATURE;
    }
}

