/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class ItemButton
extends Button {
    private final ItemStack itemStack;
    private final boolean inContainer;
    private ClientTooltipPositioner tooltipPositioner;
    private float hoverProgress;
    private float pressTime = -1.0f;
    @Nullable
    public Consumer<ItemButton> f_93717_;
    @Nullable
    public Consumer<ItemButton> onRelease;

    protected ItemButton(Builder builder) {
        super((Button.Builder)builder);
        this.itemStack = builder.itemStack;
        this.inContainer = builder.inContainer;
    }

    public static Builder builder(ItemStack itemStack, boolean inContainer, Button.OnPress pOnPress) {
        return new Builder(itemStack, inContainer, pOnPress);
    }

    public ItemStack item() {
        return this.itemStack;
    }

    public int pressTime() {
        return (int)this.pressTime;
    }

    public void unpress() {
        this.pressTime = -1.0f;
    }

    protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.pressTime >= 0.0f) {
            int i = (int)this.pressTime;
            this.pressTime += pPartialTick;
            if (this.f_93717_ != null && i != (int)this.pressTime) {
                this.f_93717_.accept(this);
            }
        }
        int x = this.m_252754_();
        int y = this.m_252907_();
        int width = this.m_5711_() - 1;
        int height = this.m_93694_() - 1;
        if (this.inContainer) {
            pGuiGraphics.m_280509_(x + 1, y + 1, x + width - 1, y + height - 1, 0x222222 | (int)(this.f_93625_ * 255.0f) << 24);
        } else {
            pGuiGraphics.m_280509_(x, y, x + width, y + height, 0x222222 | (int)(this.f_93625_ * 255.0f) << 24);
        }
        this.hoverProgress += this.m_198029_() ? pPartialTick * 0.2f : -pPartialTick * 0.2f;
        this.hoverProgress = Mth.m_14036_((float)this.hoverProgress, (float)(this.inContainer ? 0.0f : 0.4f), (float)1.0f);
        int lineColor = 0xFFFFFF | (int)(this.hoverProgress * 255.0f) << 24;
        pGuiGraphics.m_280509_(x, y, x + 1, y + height, lineColor);
        pGuiGraphics.m_280509_(x + width - 1, y, x + width, y + height, lineColor);
        pGuiGraphics.m_280509_(x + 1, y, x + width - 1, y + 1, lineColor);
        pGuiGraphics.m_280509_(x + 1, y + height - 1, x + width - 1, y + height, lineColor);
        pGuiGraphics.m_280480_(this.itemStack, x + 2, y + 2);
    }

    public void setTooltipPositioner(ClientTooltipPositioner tooltipPositioner) {
        this.tooltipPositioner = tooltipPositioner;
    }

    protected ClientTooltipPositioner m_262860_() {
        return this.tooltipPositioner != null ? this.tooltipPositioner : super.m_262860_();
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
        this.pressTime = 0.0f;
    }

    public void m_7691_(double mouseX, double mouseY) {
        if (this.onRelease != null && this.pressTime >= 0.0f) {
            this.onRelease.accept(this);
        }
        this.pressTime = -1.0f;
    }

    public static class Builder
    extends Button.Builder {
        private final ItemStack itemStack;
        private final boolean inContainer;

        protected Builder(ItemStack itemStack, boolean inContainer, Button.OnPress pOnPress) {
            super(itemStack.m_41786_(), pOnPress);
            this.itemStack = itemStack;
            this.inContainer = inContainer;
        }

        public ItemButton build() {
            return new ItemButton(this);
        }
    }
}

