/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fusion;

import java.util.Collections;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.multiblock.IMultiblockEjector;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.util.CableUtils;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityFusionReactorPort
extends TileEntityFusionReactorBlock
implements IMultiblockEjector {
    private Set<Direction> outputDirections = Collections.emptySet();

    public TileEntityFusionReactorPort(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.FUSION_REACTOR_PORT, pos, state);
        this.delaySupplier = NO_DELAY;
    }

    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getGasTanks(side);
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getFluidTanks(side);
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getEnergyContainers(side);
    }

    @NotNull
    protected IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, CachedAmbientTemperature ambientTemperature) {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getHeatCapacitors(side);
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getInventorySlots(side);
    }

    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.GAS || type == SubstanceType.FLUID || type == SubstanceType.ENERGY || type == SubstanceType.HEAT) {
            return false;
        }
        return super.persists(type);
    }

    public void setEjectSides(Set<Direction> sides) {
        this.outputDirections = sides;
    }

    protected boolean onUpdateServer(FusionReactorMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        if (this.getActive() && multiblock.isFormed()) {
            ChemicalUtil.emit(this.outputDirections, (IChemicalTank)multiblock.steamTank, (BlockEntity)this);
            CableUtils.emit(this.outputDirections, (IEnergyContainer)multiblock.energyContainer, (BlockEntity)this);
        }
        return needsPacket;
    }

    @Nullable
    public IHeatHandler getAdjacent(@NotNull Direction side) {
        BlockEntity adj;
        if (this.canHandleHeat() && this.getHeatCapacitorCount(side) > 0 && !((adj = WorldUtils.getTileEntity((BlockGetter)this.m_58904_(), (BlockPos)this.m_58899_().m_121945_(side))) instanceof TileEntityFusionReactorBlock)) {
            return CapabilityUtils.getCapability((ICapabilityProvider)adj, (Capability)Capabilities.HEAT_HANDLER, (Direction)side.m_122424_()).resolve().orElse(null);
        }
        return null;
    }

    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            boolean oldMode = this.getActive();
            this.setActive(!oldMode);
            player.m_5661_((Component)GeneratorsLang.REACTOR_PORT_EJECT.translateColored(EnumColor.GRAY, new Object[]{BooleanStateDisplay.InputOutput.of((boolean)oldMode, (boolean)true)}), true);
        }
        return InteractionResult.SUCCESS;
    }

    public int getRedstoneLevel() {
        return ((FusionReactorMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }

    public boolean exposesMultiblockToComputer() {
        return false;
    }

    @ComputerMethod(methodDescription="true -> output, false -> input")
    boolean getMode() {
        return this.getActive();
    }

    @ComputerMethod(methodDescription="true -> output, false -> input")
    void setMode(boolean output) {
        this.setActive(output);
    }
}

