/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.decoration;

import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import net.potionstudios.biomeswevegone.world.item.custom.WreathItem;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Wreath
extends HangingEntity
implements VariantHolder<Type> {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(Wreath.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Wreath(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
        this.setVariant(Type.DEFAULT);
    }

    public Wreath(Level level, BlockPos pos, Direction facingDirection, Type type) {
        this(BWGEntityType.WREATH.get(), level, pos, facingDirection, type);
    }

    public Wreath(EntityType<? extends HangingEntity> entityType, Level level, BlockPos pos, Direction facingDirection, Type type) {
        super(entityType, level, pos);
        this.setVariant(type);
        this.m_6022_(facingDirection);
    }

    protected void m_6022_(@NotNull Direction facingDirection) {
        Validate.notNull((Object)facingDirection);
        this.f_31699_ = facingDirection;
        if (facingDirection.m_122434_().m_122479_()) {
            this.m_146926_(0.0f);
            this.m_146922_(this.f_31699_.m_122416_() * 90);
        } else {
            this.m_146926_(-90 * facingDirection.m_122421_().m_122540_());
            this.m_146922_(0.0f);
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_7087_();
    }

    protected void m_7087_() {
        if (this.f_31699_ != null) {
            double e = (double)this.f_31698_.m_123341_() + 0.5 - (double)this.f_31699_.m_122429_() * 0.46875;
            double f = (double)this.f_31698_.m_123342_() + 0.5 - (double)this.f_31699_.m_122430_() * 0.46875;
            double g = (double)this.f_31698_.m_123343_() + 0.5 - (double)this.f_31699_.m_122431_() * 0.46875;
            this.m_20343_(e, f, g);
            double h = this.m_7076_();
            double i = this.m_7068_();
            double j = this.m_7076_();
            Direction.Axis axis = this.f_31699_.m_122434_();
            switch (axis) {
                case X: {
                    h = 1.0;
                    break;
                }
                case Y: {
                    i = 1.0;
                    break;
                }
                case Z: {
                    j = 1.0;
                }
            }
            this.m_20011_(new AABB(e - (h /= 32.0), f - (i /= 32.0), g - (j /= 32.0), e + h, f + i, g + j));
        }
    }

    public boolean m_7088_() {
        if (!this.m_9236_().m_45786_((Entity)this)) {
            return false;
        }
        BlockState blockState = this.m_9236_().m_8055_(this.f_31698_.m_121945_(this.f_31699_.m_122424_()));
        return (blockState.m_280296_() || this.f_31699_.m_122434_().m_122479_() && DiodeBlock.m_52586_((BlockState)blockState)) && this.m_9236_().m_6249_((Entity)this, this.m_20191_(), f_31697_).isEmpty();
    }

    public int m_7076_() {
        return 16;
    }

    public int m_7068_() {
        return 16;
    }

    public void m_5553_(@Nullable Entity brokenEntity) {
        block2: {
            block4: {
                block3: {
                    if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) break block2;
                    this.m_216990_(SoundEvents.f_144073_);
                    if (!(brokenEntity instanceof Player)) break block3;
                    Player player = (Player)brokenEntity;
                    if (player.m_150110_().f_35937_) break block4;
                }
                this.m_19998_((ItemLike)this.getVariant().getItem());
            }
            this.m_146852_(GameEvent.f_157792_, brokenEntity);
        }
    }

    public void m_7084_() {
        this.m_216990_(SoundEvents.f_144057_);
    }

    public void setVariant(@NotNull Type variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)variant.ordinal());
    }

    @NotNull
    public Type getVariant() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE, (Object)Type.DEFAULT.ordinal());
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Type", this.getVariant().m_7912_());
        compound.m_128344_("Facing", (byte)this.f_31699_.m_122411_());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Type", 8)) {
            this.setVariant(Type.byName(compound.m_128461_("Type")));
        }
        this.m_6022_(Direction.m_122376_((int)compound.m_128445_("Facing")));
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.f_31699_.m_122411_(), this.m_31748_());
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.m_6022_(Direction.m_122376_((int)packet.m_131509_()));
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.getVariant().getItem().m_7968_();
    }

    @NotNull
    protected Component m_5677_() {
        return Component.m_237115_((String)this.getVariant().getItem().m_5524_());
    }

    public static enum Type implements StringRepresentable
    {
        HOLLY("holly", () -> BWGItems.HOLLY_WREATH),
        MUSHROOM("mushroom", () -> BWGItems.MUSHROOM_WREATH),
        ODDION("oddion", () -> BWGItems.ODDION_WREATH),
        PETAL("petal", () -> BWGItems.PETAL_WREATH),
        ROSY("rosy", () -> BWGItems.ROSY_WREATH),
        WINTER_ROSY("winter_rosy", () -> BWGItems.WINTER_ROSY_WREATH),
        DEFAULT("default", () -> BWGItems.WREATH);

        private final String name;
        private final Supplier<Supplier<WreathItem>> item;
        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;

        private Type(String name, Supplier<Supplier<WreathItem>> item) {
            this.name = name;
            this.item = item;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public WreathItem getItem() {
            return this.item.get().get();
        }

        public static Type byId(int id) {
            return BY_ID.apply(id);
        }

        public static Type byName(String name) {
            return (Type)CODEC.m_262792_(name, (Enum)DEFAULT);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
            BY_ID = ByIdMap.m_262839_(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

