/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.biome;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.potionstudios.biomeswevegone.util.BWGUtil;

public class BWGRegionUtils {
    @SafeVarargs
    public static void dumpArrays(Consumer<ResourceKey<Biome>> biomeConsumer, ResourceKey<Biome>[][] ... resourceKeys) {
        ResourceKey<Biome>[][][] resourceKeyArray = resourceKeys;
        int n = resourceKeyArray.length;
        for (int i = 0; i < n; ++i) {
            ResourceKey<Biome>[][] resourceKey;
            ResourceKey<Biome>[][] resourceKeyArray2 = resourceKey = resourceKeyArray[i];
            int n2 = resourceKeyArray2.length;
            for (int j = 0; j < n2; ++j) {
                ResourceKey<Biome>[] keys;
                for (ResourceKey<Biome> key : keys = resourceKeyArray2[j]) {
                    biomeConsumer.accept(key);
                }
            }
        }
    }

    public static ResourceKey<Biome>[][] filter(String configKey, ResourceLocation regionName, int configIDX, ResourceKey<Biome>[][] biomeArray, Predicate<ResourceKey<Biome>> filter, boolean throwsException) {
        return (ResourceKey[][])Arrays.stream(biomeArray).map(resourceKeys -> (ResourceKey[])Arrays.stream(resourceKeys).map(key -> !filter.test((ResourceKey<Biome>)key) ? null : key).peek(biomeResourceKey -> {
            if (biomeResourceKey == null && throwsException) {
                String error = String.format("\"%s\" is not an allowed entry, specify a valid biome key!\nBWG OverworldRegion: \"%s\" failed in biome array: \"%s\" in region %s.\nCurrent value:\n%s", Biomes.f_48173_.m_135782_(), regionName.toString(), configKey, configIDX, BWGUtil.print2DResourceKeyArray(biomeArray));
                throw new IllegalArgumentException(error);
            }
        }).toList().toArray(ResourceKey[]::new)).toArray(x$0 -> new ResourceKey[x$0][]);
    }
}

