/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.biomeswevegone.util.UnsafeBoundingBox;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructureTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch.ArchConfig;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch.ArchPiece;
import org.jetbrains.annotations.NotNull;

public class ArchStructure
extends Structure {
    public static final BoundingBox INFINITE = BoundingBox.m_71044_();
    public static final Codec<ArchStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ArchStructure.m_226567_((RecordCodecBuilder.Instance)builder), (App)ArchConfig.CODEC.fieldOf("config").forGetter(archStructure -> archStructure.config)).apply((Applicative)builder, ArchStructure::new)).codec();
    private final ArchConfig config;

    public ArchStructure(Structure.StructureSettings settings, ArchConfig config) {
        super(settings);
        this.config = config;
    }

    @NotNull
    protected Optional<Structure.GenerationStub> m_214086_(@NotNull Structure.GenerationContext context) {
        return ArchStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR, structurePiecesBuilder -> {
            ChunkPos chunkPos = context.f_226628_();
            WorldgenRandom random = context.f_226626_();
            int blockX = chunkPos.m_151382_(random.m_188503_(16));
            int blockZ = chunkPos.m_151391_(random.m_188503_(16));
            ChunkGenerator chunkGenerator = context.f_226622_();
            int blockY = chunkGenerator.m_214096_(blockX, blockZ, Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_());
            int yOffset = this.config.height().m_214085_((RandomSource)random);
            BlockPos structureCenter = new BlockPos(blockX, blockY, blockZ);
            Vec3 originVec3 = Vec3.m_82512_((Vec3i)structureCenter);
            BlockPos offset = new BlockPos(this.config.length().m_214085_((RandomSource)random) / 2 * (random.m_188499_() ? 1 : -1), 0, this.config.length().m_214085_((RandomSource)random) / 2 * (random.m_188499_() ? 1 : -1));
            BlockPos first = structureCenter.m_121955_((Vec3i)offset);
            first = first.m_175288_(chunkGenerator.m_214096_(first.m_123341_(), first.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_()) - 10);
            Vec3 firstVec3 = Vec3.m_82512_((Vec3i)first);
            BlockPos second = structureCenter.m_121996_((Vec3i)offset);
            second = second.m_175288_(chunkGenerator.m_214096_(second.m_123341_(), second.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_()) - 10);
            Vec3 secondVec3 = Vec3.m_82512_((Vec3i)second);
            Long2ObjectOpenHashMap generatingChunks = new Long2ObjectOpenHashMap();
            Consumer<BlockPos> stepAction = position -> ((UnsafeBoundingBox)generatingChunks.computeIfAbsent(ChunkPos.m_151388_((BlockPos)position), key -> new UnsafeBoundingBox())).encapsulate((Vec3i)position);
            this.config.archGeneratorConfig().generate(context.f_226627_() + structureCenter.m_121878_(), yOffset, firstVec3, originVec3, secondVec3, INFINITE, stepAction);
            BlockPos finalFirst = first;
            BlockPos finalSecond = second;
            generatingChunks.long2ObjectEntrySet().fastForEach(unsafeBoundingBoxEntry -> structurePiecesBuilder.m_142679_((StructurePiece)new ArchPiece(((UnsafeBoundingBox)unsafeBoundingBoxEntry.getValue()).toBoundingBox(), structureCenter, finalFirst, finalSecond, yOffset, this.config.archGeneratorConfig(), this.config.checkedBlockPlacement())));
        });
    }

    public static void between(Vec3 center, Vec3 second, double xzStepDistance, int yOffset, double step3dDistance, BlendingFunction blendingFunction, Consumer<BlockPos> stepAction) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        Vec3 xzDifference = center.m_82546_(second);
        double xzDistance = xzDifference.m_165924_();
        double xzTotalSteps = xzDistance / xzStepDistance;
        int step = 0;
        while ((double)step < xzTotalSteps) {
            double factor = (double)step / xzTotalSteps;
            Vec3 stepVec3 = center.m_82549_(xzDifference.m_82541_().m_82490_((double)step * xzStepDistance));
            double yPos = blendingFunction.apply(1.0 - factor, second.f_82480_, center.f_82480_ + (double)yOffset);
            Vec3 stepVec3YOffset = new Vec3(stepVec3.f_82479_, yPos, stepVec3.f_82481_);
            int nextStep = step + 1;
            double nextFactor = (double)nextStep / xzTotalSteps;
            Vec3 nextStepVec3 = center.m_82549_(xzDifference.m_82541_().m_82490_((double)nextStep * xzStepDistance));
            double nextYPos = blendingFunction.apply(1.0 - nextFactor, second.f_82480_, center.f_82480_ + (double)yOffset);
            Vec3 nextStepVec3YOffset = new Vec3(nextStepVec3.f_82479_, nextYPos, nextStepVec3.f_82481_);
            ArchStructure.between3D(step3dDistance, nextStepVec3YOffset, stepVec3YOffset, mutableBlockPos, stepAction);
            ++step;
        }
    }

    private static void between3D(double step3dDistance, Vec3 nextStepVec3YOffset, Vec3 stepVec3YOffset, BlockPos.MutableBlockPos mutableBlockPos, Consumer<BlockPos> stepAction) {
        Vec3 difference3D = nextStepVec3YOffset.m_82546_(stepVec3YOffset);
        double distance3d = difference3D.m_82553_();
        double totalSteps3D = distance3d / step3dDistance;
        int step3D = 0;
        while ((double)step3D <= totalSteps3D) {
            Vec3 step3DVec3 = stepVec3YOffset.m_82549_(difference3D.m_82541_().m_82490_((double)step3D * step3dDistance));
            mutableBlockPos.m_122169_(step3DVec3.f_82479_, step3DVec3.f_82480_, step3DVec3.f_82481_);
            stepAction.accept(mutableBlockPos.m_7949_());
            ++step3D;
        }
    }

    public static void generate(long seed, double thickness, double frequency, BlockPos stepOrigin, BoundingBox effectedArea, Consumer<BlockPos> action) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        ImprovedNoise noise = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(seed));
        if (!effectedArea.equals((Object)INFINITE) && !effectedArea.m_191961_((int)thickness + 1).m_71051_((Vec3i)stepOrigin)) {
            return;
        }
        for (double x = -thickness; x <= thickness; x += 1.0) {
            for (double y = -thickness; y <= thickness; y += 1.0) {
                for (double z = -thickness; z <= thickness; z += 1.0) {
                    mutableBlockPos.m_122154_((Vec3i)stepOrigin, (int)x, (int)y, (int)z);
                    if (!effectedArea.equals((Object)INFINITE) && !effectedArea.m_71051_((Vec3i)mutableBlockPos) || !(stepOrigin.m_123331_((Vec3i)mutableBlockPos) < Mth.m_144952_((double)thickness))) continue;
                    double noiseSample = (noise.m_164308_((double)mutableBlockPos.m_123341_() * frequency, (double)mutableBlockPos.m_123342_() * frequency, (double)mutableBlockPos.m_123343_() * frequency) + 1.0) * 0.5;
                    double localRadius = Mth.m_14085_((double)(thickness * 0.5), (double)thickness, (double)noiseSample);
                    if (!(stepOrigin.m_123331_((Vec3i)mutableBlockPos) < Mth.m_144952_((double)localRadius))) continue;
                    action.accept((BlockPos)mutableBlockPos);
                }
            }
        }
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return BWGStructureTypes.ARCH.get();
    }
}

