/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.VariableHelper;

public interface IVariable {
    public <T> T as(Class<T> var1);

    default public <T> T as(Class<T> clazz, T def) {
        return this.unwrap().isJsonNull() ? def : this.as(clazz);
    }

    public JsonElement unwrap();

    default public String asString() {
        return this.asString("");
    }

    default public String asString(String def) {
        return this.unwrap().isJsonNull() ? def : this.unwrap().getAsString();
    }

    default public Number asNumber() {
        return this.asNumber(0);
    }

    default public Number asNumber(Number def) {
        return this.unwrap().isJsonNull() ? (Number)def : (Number)this.unwrap().getAsNumber();
    }

    default public boolean asBoolean() {
        return this.asBoolean(false);
    }

    default public boolean asBoolean(boolean def) {
        return this.unwrap().isJsonNull() ? def : !this.unwrap().getAsString().equals("false") && !this.unwrap().getAsString().isEmpty() && this.unwrap().getAsBoolean();
    }

    default public Stream<IVariable> asStream() {
        return StreamSupport.stream(this.unwrap().getAsJsonArray().spliterator(), false).map(IVariable::wrap);
    }

    default public Stream<IVariable> asStreamOrSingleton() {
        return this.unwrap().isJsonArray() ? this.asStream() : Stream.of(this);
    }

    default public List<IVariable> asList() {
        return this.asStream().collect(Collectors.toList());
    }

    default public List<IVariable> asListOrSingleton() {
        return this.asStreamOrSingleton().collect(Collectors.toList());
    }

    public static <T> IVariable from(@Nullable T object) {
        return object != null ? VariableHelper.instance().createFromObject(object) : IVariable.empty();
    }

    public static IVariable wrap(@Nullable JsonElement elem) {
        return elem != null ? VariableHelper.instance().createFromJson(elem) : IVariable.empty();
    }

    public static IVariable wrapList(Iterable<IVariable> elems) {
        JsonArray arr = new JsonArray();
        for (IVariable v : elems) {
            arr.add(v.unwrap());
        }
        return IVariable.wrap((JsonElement)arr);
    }

    public static IVariable wrap(@Nullable Number n) {
        return n != null ? IVariable.wrap((JsonElement)new JsonPrimitive(n)) : IVariable.empty();
    }

    public static IVariable wrap(@Nullable Boolean b) {
        return b != null ? IVariable.wrap((JsonElement)new JsonPrimitive(b)) : IVariable.empty();
    }

    public static IVariable wrap(@Nullable String s) {
        return s != null ? IVariable.wrap((JsonElement)new JsonPrimitive(s)) : IVariable.empty();
    }

    public static IVariable empty() {
        return IVariable.wrap((JsonElement)JsonNull.INSTANCE);
    }

    public static class Serializer
    implements JsonDeserializer<IVariable> {
        public IVariable deserialize(JsonElement elem, Type t, JsonDeserializationContext c) {
            return IVariable.wrap(elem);
        }
    }
}

