/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.entity;

import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.mobs.ai.RaveGoal;
import org.violetmoon.quark.content.mobs.module.CrabsModule;

public class Crab
extends Animal
implements IEntityAdditionalSpawnData,
Bucketable {
    public static final int COLORS = 3;
    public static final ResourceLocation CRAB_LOOT_TABLE = new ResourceLocation("quark", "entities/crab");
    private static final EntityDataAccessor<Float> SIZE_MODIFIER = SynchedEntityData.m_135353_(Crab.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Crab.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> RAVING = SynchedEntityData.m_135353_(Crab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(Crab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lightningCooldown;
    private Ingredient temptationItems;
    private boolean noSpike;
    private BlockPos jukeboxPosition;
    private final DynamicGameEventListener<JukeboxListener> dynamicJukeboxListener;

    public Crab(EntityType<? extends Crab> type, Level worldIn) {
        this(type, worldIn, 1.0f);
    }

    public Crab(EntityType<? extends Crab> type, Level worldIn, float sizeModifier) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        if (sizeModifier != 1.0f) {
            this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
        }
        EntityPositionSource source = new EntityPositionSource((Entity)this, this.m_20192_());
        this.dynamicJukeboxListener = new DynamicGameEventListener((GameEventListener)new JukeboxListener((PositionSource)source, GameEvent.f_238690_.m_157827_()));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public void m_6872_(@NotNull ItemStack stack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)stack);
        CompoundTag tag = stack.m_41784_();
        if (this.noSpike) {
            tag.m_128379_("NoSpike", true);
        }
        tag.m_128405_("Variant", this.getVariant());
    }

    public void m_142278_(@NotNull CompoundTag tag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
        if (tag.m_128441_("NoSpike")) {
            this.noSpike = tag.m_128471_("NoSpike");
        }
        this.f_19804_.m_135381_(VARIANT, (Object)tag.m_128451_("Variant"));
    }

    @NotNull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)CrabsModule.crab_bucket);
    }

    @NotNull
    public SoundEvent m_142623_() {
        return QuarkSounds.BUCKET_FILL_CRAB;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public void m_213651_(@NotNull BiConsumer<DynamicGameEventListener<?>, ServerLevel> acceptor) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            acceptor.accept(this.dynamicJukeboxListener, serverlevel);
        }
    }

    public static boolean spawnPredicate(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(CrabsModule.crabSpawnableTag) && world.m_46803_(pos) > 8;
    }

    public float m_5610_(BlockPos pos, LevelReader world) {
        return world.m_8055_(pos.m_7495_()).m_204336_(CrabsModule.crabSpawnableTag) ? 10.0f : (float)world.m_45524_(pos, 0) - 0.5f;
    }

    public boolean m_6040_() {
        return true;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE_MODIFIER, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(VARIANT, (Object)-1);
        this.f_19804_.m_135372_(RAVING, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.getSizeModifier() >= 2.0f) {
            if (!(this.m_6898_(player.m_21120_(hand)) || this.m_20160_() || player.m_36341_())) {
                if (!this.m_9236_().f_46443_) {
                    player.m_20329_((Entity)this);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        } else {
            Optional result = Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this);
            if (result.isPresent()) {
                return (InteractionResult)result.get();
            }
        }
        return super.m_6071_(player, hand);
    }

    public double m_6048_() {
        return super.m_6048_() / 0.75 * 0.9;
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity entity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() != Direction.Axis.Y) {
            float scale = this.m_6134_();
            int[][] aint = DismountHelper.m_38467_((Direction)direction);
            BlockPos blockpos = this.m_20183_();
            BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
            for (Pose pose : entity.m_7431_()) {
                AABB aabb = entity.m_21270_(pose);
                for (int[] aint1 : aint) {
                    mutPos.m_122169_((double)((float)blockpos.m_123341_() + (float)aint1[0] * scale), (double)blockpos.m_123342_(), (double)((float)blockpos.m_123343_() + (float)aint1[1] * scale));
                    double d0 = this.m_9236_().m_45573_((BlockPos)mutPos);
                    if (!DismountHelper.m_38439_((double)d0)) continue;
                    Vec3 vec3 = Vec3.m_82514_((Vec3i)mutPos, (double)d0);
                    if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)entity, (AABB)aabb.m_82383_(vec3))) continue;
                    entity.m_20124_(pose);
                    return vec3;
                }
            }
        }
        return super.m_7688_(entity);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return QuarkSounds.ENTITY_CRAB_IDLE;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return QuarkSounds.ENTITY_CRAB_DIE;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return QuarkSounds.ENTITY_CRAB_HURT;
    }

    protected float m_6431_(@NotNull Pose pose, EntityDimensions size) {
        return 0.2f * size.f_20378_;
    }

    public float getSizeModifier() {
        return ((Float)this.f_19804_.m_135370_(SIZE_MODIFIER)).floatValue();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new RaveGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, this.getTemptationItems(), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22285_, 2.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && (Integer)this.f_19804_.m_135370_(VARIANT) == -1) {
            int variant = 0;
            if (this.f_19796_.m_188499_()) {
                variant += this.f_19796_.m_188503_(2) + 1;
            }
            if (this.f_19796_.m_188503_(3) == 0) {
                variant += 3;
            }
            this.f_19804_.m_135381_(VARIANT, (Object)variant);
        }
        if (this.lightningCooldown > 0) {
            --this.lightningCooldown;
            this.m_20095_();
        }
        if (this.isRaving() && this.m_9236_().f_46443_ && this.f_19797_ % 10 == 0) {
            BlockPos below = this.m_20183_().m_7495_();
            BlockState belowState = this.m_9236_().m_8055_(below);
            if (belowState.m_204336_(BlockTags.f_13029_)) {
                this.m_9236_().m_46796_(2001, below, Block.m_49956_((BlockState)belowState));
            }
        }
        if (this.isRaving() && !this.m_9236_().f_46443_ && this.f_19797_ % 20 == 0 && this.shouldStopRaving()) {
            this.setRaving(false);
            this.jukeboxPosition = null;
        }
    }

    public float getStepHeight() {
        float baseStep = this.f_19798_ ? 1.0f : 0.6f;
        AttributeInstance stepHeightAttribute = this.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        if (stepHeightAttribute != null) {
            return (float)Math.max(0.0, (double)baseStep + stepHeightAttribute.m_22135_());
        }
        return baseStep;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose poseIn) {
        return super.m_6972_(poseIn).m_20388_(this.getSizeModifier());
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        DamageSources sources = this.m_9236_().m_269111_();
        return super.m_6673_(source) || source == sources.m_269325_() || source == sources.m_269555_() || source == sources.m_269548_() || this.getSizeModifier() > 1.0f && source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_);
    }

    public boolean m_5825_() {
        return super.m_5825_() || this.getSizeModifier() > 1.0f;
    }

    public void m_8038_(@NotNull ServerLevel sworld, @NotNull LightningBolt lightningBolt) {
        if (this.lightningCooldown > 0 || this.m_9236_().f_46443_) {
            return;
        }
        float sizeMod = this.getSizeModifier();
        if (sizeMod <= 15.0f) {
            AttributeInstance armorAttr;
            AttributeInstance speedAttr;
            AttributeInstance healthAttr = this.m_21051_(Attributes.f_22276_);
            if (healthAttr != null) {
                healthAttr.m_22125_(new AttributeModifier("Lightning Bonus", 0.5, AttributeModifier.Operation.ADDITION));
            }
            if ((speedAttr = this.m_21051_(Attributes.f_22279_)) != null) {
                speedAttr.m_22125_(new AttributeModifier("Lightning Debuff", -0.05, AttributeModifier.Operation.ADDITION));
            }
            if ((armorAttr = this.m_21051_(Attributes.f_22284_)) != null) {
                armorAttr.m_22125_(new AttributeModifier("Lightning Bonus", 0.125, AttributeModifier.Operation.ADDITION));
            }
            float sizeModifier = Math.min(sizeMod + 1.0f, 16.0f);
            this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
            this.m_6210_();
            this.lightningCooldown = 150;
        }
    }

    public void m_7334_(@NotNull Entity entityIn) {
        if (this.getSizeModifier() <= 1.0f) {
            super.m_7334_(entityIn);
        }
    }

    protected void m_7324_(@NotNull Entity entityIn) {
        super.m_7324_(entityIn);
        if (this.m_9236_().m_46791_() != Difficulty.PEACEFUL && !this.noSpike && !this.m_20363_(entityIn) && entityIn instanceof LivingEntity && !(entityIn instanceof Crab)) {
            entityIn.m_6469_(this.m_9236_().m_269111_().m_269325_(), 1.0f);
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return !stack.m_41619_() && this.getTemptationItems().test(stack);
    }

    private Ingredient getTemptationItems() {
        if (this.temptationItems == null) {
            this.temptationItems = Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("quark", "crab_tempt_items")));
        }
        return this.temptationItems;
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel sworld, @NotNull AgeableMob other) {
        return new Crab(CrabsModule.crabType, this.m_9236_());
    }

    @NotNull
    protected ResourceLocation m_7582_() {
        return CRAB_LOOT_TABLE;
    }

    public int getVariant() {
        return Math.max(0, (Integer)this.f_19804_.m_135370_(VARIANT));
    }

    public void party(BlockPos pos, boolean isPartying) {
        if (isPartying) {
            if (!this.isRaving()) {
                this.jukeboxPosition = pos;
                this.setRaving(true);
            }
        } else if (pos.equals((Object)this.jukeboxPosition) || this.jukeboxPosition == null) {
            this.jukeboxPosition = null;
            this.setRaving(false);
        }
    }

    public boolean shouldStopRaving() {
        return this.jukeboxPosition == null || !this.jukeboxPosition.m_203195_((Position)this.m_20182_(), (double)GameEvent.f_238690_.m_157827_()) || !this.m_9236_().m_8055_(this.jukeboxPosition).m_60713_(Blocks.f_50131_);
    }

    public boolean isRaving() {
        return (Boolean)this.f_19804_.m_135370_(RAVING);
    }

    public void setRaving(boolean raving) {
        this.f_19804_.m_135381_(RAVING, (Object)raving);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> parameter) {
        if (parameter.equals(SIZE_MODIFIER)) {
            this.m_6210_();
        }
        super.m_7350_(parameter);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.getSizeModifier());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(buffer.readFloat()));
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.lightningCooldown = compound.m_128451_("LightningCooldown");
        this.noSpike = compound.m_128471_("NoSpike");
        if (compound.m_128441_("EnemyCrabRating")) {
            float sizeModifier = compound.m_128457_("EnemyCrabRating");
            this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
        }
        if (compound.m_128441_("Variant")) {
            this.f_19804_.m_135381_(VARIANT, (Object)compound.m_128451_("Variant"));
        }
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("EnemyCrabRating", this.getSizeModifier());
        compound.m_128405_("LightningCooldown", this.lightningCooldown);
        compound.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
        compound.m_128379_("NoSpike", this.noSpike);
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public class JukeboxListener
    implements GameEventListener {
        private final PositionSource listenerSource;
        private final int listenerRadius;

        public JukeboxListener(PositionSource source, int radius) {
            this.listenerSource = source;
            this.listenerRadius = radius;
        }

        @NotNull
        public PositionSource m_142460_() {
            return this.listenerSource;
        }

        public int m_142078_() {
            return this.listenerRadius;
        }

        public boolean m_214068_(@NotNull ServerLevel serverLevel, @NotNull GameEvent gameEvent, @NotNull GameEvent.Context context, @NotNull Vec3 vec3) {
            if (gameEvent == GameEvent.f_238690_) {
                Crab.this.party(BlockPos.m_274446_((Position)vec3), true);
                return true;
            }
            if (gameEvent == GameEvent.f_238649_) {
                Crab.this.party(BlockPos.m_274446_((Position)vec3), false);
                return true;
            }
            return false;
        }
    }
}

