/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.biomemodifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public class RemoveCarversBiomeModifierForge
implements BiomeModifier {
    public static Codec<RemoveCarversBiomeModifierForge> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(modifier -> modifier.biomes), (App)ConfiguredWorldCarver.f_64848_.fieldOf("carvers").forGetter(modifier -> modifier.carvers)).apply((Applicative)builder, RemoveCarversBiomeModifierForge::new));
    private final HolderSet<Biome> biomes;
    private final HolderSet<ConfiguredWorldCarver<?>> carvers;

    public RemoveCarversBiomeModifierForge(HolderSet<Biome> biomes, HolderSet<ConfiguredWorldCarver<?>> carvers) {
        this.biomes = biomes;
        this.carvers = carvers;
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (this.biomes.m_203333_(biome) && phase == BiomeModifier.Phase.ADD) {
            this.carvers.forEach(carver -> builder.getGenerationSettings().getCarvers(GenerationStep.Carving.AIR).remove(carver));
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

