/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.layer;

import com.yungnickyoung.minecraft.bettercaves.BetterCavesCommon;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseUtils;
import com.yungnickyoung.minecraft.bettercaves.worldgen.BetterCavesWorldCarverConfig;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.AbstractCarver;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.CarverNoiseRange;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.CavernCarver;
import com.yungnickyoung.minecraft.yungsapi.math.ColPos;
import com.yungnickyoung.minecraft.yungsapi.noise.FastNoise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;

public class CavernLayer {
    private final FastNoise cavernRegionSampler;
    private final List<CarverNoiseRange> noiseRanges = new ArrayList<CarverNoiseRange>();
    private final BetterCavesWorldCarverConfig config;
    private final boolean isDebugViewEnabled;
    private final boolean isOverrideSurfaceDetectionEnabled;

    public CavernLayer(ServerLevel serverLevel, BetterCavesWorldCarverConfig config, BetterCavesWorldCarverConfig.CavernLayerSettings layerSettings) {
        this.config = config;
        this.isDebugViewEnabled = config.debugSettings.enabled();
        this.isOverrideSurfaceDetectionEnabled = config.misc.overrideSurfaceDetection();
        double cavernRegionSize = layerSettings.cavernRegionSizeFrequency();
        this.cavernRegionSampler = new FastNoise();
        this.cavernRegionSampler.SetSeed((int)serverLevel.m_7328_() + 333);
        this.cavernRegionSampler.SetFrequency((float)cavernRegionSize);
        List<AbstractCarver> carvers = CavernCarver.createCarversFromConfig(serverLevel, config, layerSettings);
        float spawnChance = (float)(layerSettings.cavernSpawnChance() / 100.0);
        int totalSpawnWeight = carvers.stream().map(AbstractCarver::getSpawnWeight).reduce(0, Integer::sum);
        BetterCavesCommon.LOGGER.debug("CAVERN INFORMATION");
        BetterCavesCommon.LOGGER.debug("--> SPAWN CHANCE SET TO: {}", (Object)Float.valueOf(spawnChance));
        BetterCavesCommon.LOGGER.debug("--> TOTAL SPAWN WEIGHT: {}", (Object)totalSpawnWeight);
        carvers.removeIf(carver -> carver.getSpawnWeight() == 0);
        float totalDeadzonePercent = 1.0f - spawnChance;
        float deadzonePercent = carvers.size() > 1 ? totalDeadzonePercent / (float)(carvers.size() - 1) : totalDeadzonePercent;
        BetterCavesCommon.LOGGER.debug("--> DEADZONE PERCENT: {}({} TOTAL)", (Object)Float.valueOf(deadzonePercent), (Object)Float.valueOf(totalDeadzonePercent));
        float currNoise = -1.0f;
        for (AbstractCarver carver2 : carvers) {
            BetterCavesCommon.LOGGER.debug("--> CARVER");
            float rangeCDFPercent = (float)carver2.getSpawnWeight() / (float)totalSpawnWeight * spawnChance;
            float topNoise = NoiseUtils.simplexNoiseOffsetByPercent(currNoise, rangeCDFPercent);
            CarverNoiseRange range = new CarverNoiseRange(currNoise, topNoise, carver2);
            this.noiseRanges.add(range);
            currNoise = NoiseUtils.simplexNoiseOffsetByPercent(topNoise, deadzonePercent);
            BetterCavesCommon.LOGGER.debug("    --> RANGE PERCENT LENGTH WANTED: {}", (Object)Float.valueOf(rangeCDFPercent));
            BetterCavesCommon.LOGGER.debug("    --> RANGE FOUND: {}", (Object)range);
        }
    }

    public void carveChunk(ChunkAccess chunkAccess, int[][] surfaceAltitudes, BlockState[][] liquidBlocks, Function<BlockPos, Holder<Biome>> biomeProvider, CarvingMask carvingMask, Aquifer aquifer) {
        if (this.noiseRanges.isEmpty()) {
            return;
        }
        float smoothAmpFloodFactor = 1.0f;
        for (int subX = 0; subX < 4; ++subX) {
            for (int subZ = 0; subZ < 4; ++subZ) {
                int localSubStartX = subX * 4;
                int localSubStartZ = subZ * 4;
                int localSubEndX = localSubStartX + 4 - 1;
                int localSubEndZ = localSubStartZ + 4 - 1;
                BlockPos startPos = new BlockPos(chunkAccess.m_7697_().f_45578_ * 16 + localSubStartX, 1, chunkAccess.m_7697_().f_45579_ * 16 + localSubStartZ);
                BlockPos endPos = new BlockPos(chunkAccess.m_7697_().f_45578_ * 16 + localSubEndX, 1, chunkAccess.m_7697_().f_45579_ * 16 + localSubEndZ);
                int maxHeight = Integer.MIN_VALUE;
                if (!this.isOverrideSurfaceDetectionEnabled) {
                    for (int x = localSubStartX; x < localSubEndX; ++x) {
                        for (int z = localSubStartZ; z < localSubEndZ; ++z) {
                            maxHeight = Math.max(maxHeight, surfaceAltitudes[x][z]);
                        }
                    }
                    for (CarverNoiseRange range : this.noiseRanges) {
                        CavernCarver carver = (CavernCarver)range.getCarver();
                        maxHeight = Math.max(maxHeight, carver.getTopY());
                    }
                } else {
                    for (CarverNoiseRange range : this.noiseRanges) {
                        maxHeight = Math.max(maxHeight, range.getCarver().getTopY());
                    }
                }
                HashMap<CarverNoiseRange, double[][][][]> noiseCubes = new HashMap<CarverNoiseRange, double[][][][]>();
                for (CarverNoiseRange range : this.noiseRanges) {
                    double[][][][] noiseCube = range.getCarver().getNoiseGen().interpolateNoiseCube(startPos, endPos, range.getCarver().getBottomY(), maxHeight);
                    noiseCubes.put(range, noiseCube);
                }
                for (int offsetX = 0; offsetX < 4; ++offsetX) {
                    block8: for (int offsetZ = 0; offsetZ < 4; ++offsetZ) {
                        int localX = localSubStartX + offsetX;
                        int localZ = localSubStartZ + offsetZ;
                        ColPos colPos = new ColPos(chunkAccess.m_7697_().f_45578_ * 16 + localX, chunkAccess.m_7697_().f_45579_ * 16 + localZ);
                        int surfaceAltitude = surfaceAltitudes[localX][localZ];
                        BlockState liquidBlock = liquidBlocks[localX][localZ];
                        float cavernRegionNoise = this.cavernRegionSampler.GetNoise((float)colPos.getX(), (float)colPos.getZ());
                        for (CarverNoiseRange range : this.noiseRanges) {
                            if (!range.contains(cavernRegionNoise)) continue;
                            int topY = this.isDebugViewEnabled || this.isOverrideSurfaceDetectionEnabled ? range.getCarver().getTopY() : Math.min(surfaceAltitude, range.getCarver().getTopY());
                            float smoothAmp = range.getSmoothAmp(cavernRegionNoise);
                            double[][] noiseColumn = ((double[][][][])noiseCubes.get(range))[offsetX][offsetZ];
                            ((CavernCarver)range.getCarver()).carveColumn(this.config, chunkAccess, colPos, topY, smoothAmp, noiseColumn, liquidBlock, carvingMask, aquifer);
                            continue block8;
                        }
                    }
                }
            }
        }
    }
}

