/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.xray.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import pro.mikey.xray.ClientController;
import pro.mikey.xray.Configuration;
import pro.mikey.xray.XRay;
import pro.mikey.xray.gui.GuiHelp;
import pro.mikey.xray.gui.manage.GuiAddBlock;
import pro.mikey.xray.gui.manage.GuiBlockList;
import pro.mikey.xray.gui.manage.GuiEdit;
import pro.mikey.xray.gui.utils.GuiBase;
import pro.mikey.xray.gui.utils.ScrollingList;
import pro.mikey.xray.gui.utils.SupportButton;
import pro.mikey.xray.keybinding.KeyBindings;
import pro.mikey.xray.store.BlockStore;
import pro.mikey.xray.utils.BlockData;
import pro.mikey.xray.xray.Controller;

public class GuiSelectionScreen
extends GuiBase {
    private static final ResourceLocation CIRCLE = new ResourceLocation(XRay.PREFIX_GUI + "circle.png");
    private Button distButtons;
    private EditBox search;
    public ItemRenderer render;
    private String lastSearch = "";
    private ArrayList<BlockData> itemList;
    private ArrayList<BlockData> originalList;
    private ScrollingBlockList scrollList;

    public GuiSelectionScreen() {
        super(true);
        this.setSideTitle(I18n.m_118938_((String)"xray.single.tools", (Object[])new Object[0]));
        if (ClientController.blockStore.created) {
            List<BlockData.SerializableBlockData> blocks = ClientController.blockStore.populateDefault();
            Controller.getBlockStore().setStore(BlockStore.getFromSimpleBlockList(blocks));
            ClientController.blockStore.created = false;
        }
        this.itemList = new ArrayList<BlockData>(Controller.getBlockStore().getStore().values());
        this.itemList.sort(Comparator.comparingInt(BlockData::getOrder));
        this.originalList = this.itemList;
    }

    public void m_7856_() {
        if (this.getMinecraft().f_91074_ == null) {
            return;
        }
        this.render = Minecraft.m_91087_().m_91291_();
        this.m_6702_().clear();
        this.scrollList = new ScrollingBlockList(this.getWidth() / 2 - 37, this.getHeight() / 2 + 10, 203, 185, this.itemList, this);
        this.m_142416_((GuiEventListener)this.scrollList);
        this.search = new EditBox(this.getFontRender(), this.getWidth() / 2 - 137, this.getHeight() / 2 - 105, 202, 18, (Component)Component.m_237119_());
        this.search.m_94190_(true);
        this.m_142416_((GuiEventListener)new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 - 60, 120, 20, I18n.m_118938_((String)"xray.input.add", (Object[])new Object[0]), "xray.tooltips.add_block", button -> this.getMinecraft().m_91152_((Screen)new GuiBlockList())));
        this.m_142416_((GuiEventListener)new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 - 38, 120, 20, I18n.m_118938_((String)"xray.input.add_hand", (Object[])new Object[0]), "xray.tooltips.add_block_in_hand", button -> {
            ItemStack handItem = this.getMinecraft().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
            if (!(handItem.m_41720_() instanceof BlockItem)) {
                this.getMinecraft().f_91074_.m_5661_((Component)Component.m_237113_((String)("[XRay] " + I18n.m_118938_((String)"xray.message.invalid_hand", (Object[])new Object[]{handItem.m_41786_().getString()}))), false);
                return;
            }
            this.getMinecraft().m_91152_((Screen)new GuiAddBlock(((BlockItem)handItem.m_41720_()).m_40614_(), GuiSelectionScreen::new));
        }));
        this.m_142416_((GuiEventListener)new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 - 16, 120, 20, I18n.m_118938_((String)"xray.input.add_look", (Object[])new Object[0]), "xray.tooltips.add_block_looking_at", button -> {
            LocalPlayer player = this.getMinecraft().f_91074_;
            if (this.getMinecraft().f_91073_ == null || player == null) {
                return;
            }
            this.m_7379_();
            try {
                Vec3 look = player.m_20154_();
                Vec3 start = new Vec3((double)player.m_20183_().m_123341_(), (double)((float)player.m_20183_().m_123342_() + player.m_20192_()), (double)player.m_20183_().m_123343_());
                Vec3 end = new Vec3((double)player.m_20183_().m_123341_() + look.f_82479_ * 100.0, (double)((float)player.m_20183_().m_123342_() + player.m_20192_()) + look.f_82480_ * 100.0, (double)player.m_20183_().m_123343_() + look.f_82481_ * 100.0);
                ClipContext context = new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
                BlockHitResult result = this.getMinecraft().f_91073_.m_45547_(context);
                if (result.m_6662_() == HitResult.Type.BLOCK) {
                    Block lookingAt = this.getMinecraft().f_91073_.m_8055_(result.m_82425_()).m_60734_();
                    player.m_6915_();
                    this.getMinecraft().m_91152_((Screen)new GuiAddBlock(lookingAt, GuiSelectionScreen::new));
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)("[XRay] " + I18n.m_118938_((String)"xray.message.nothing_infront", (Object[])new Object[0]))), false);
                }
            }
            catch (NullPointerException ex) {
                player.m_5661_((Component)Component.m_237113_((String)("[XRay] " + I18n.m_118938_((String)"xray.message.thats_odd", (Object[])new Object[0]))), false);
            }
        }));
        this.distButtons = new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 + 6, 120, 20, I18n.m_118938_((String)"xray.input.show-lava", (Object[])new Object[]{Controller.isLavaActive()}), "xray.tooltips.show_lava", button -> {
            Controller.toggleLava();
            button.m_93666_((Component)Component.m_237110_((String)"xray.input.show-lava", (Object[])new Object[]{Controller.isLavaActive()}));
        });
        this.m_142416_((GuiEventListener)this.distButtons);
        this.distButtons = new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 + 36, 120, 20, I18n.m_118938_((String)"xray.input.distance", (Object[])new Object[]{Controller.getVisualRadius()}), "xray.tooltips.distance", button -> {
            Controller.incrementCurrentDist();
            button.m_93666_((Component)Component.m_237110_((String)"xray.input.distance", (Object[])new Object[]{Controller.getVisualRadius()}));
        });
        this.m_142416_((GuiEventListener)this.distButtons);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"xray.single.help"), button -> this.getMinecraft().m_91152_((Screen)new GuiHelp())).m_252794_(this.getWidth() / 2 + 79, this.getHeight() / 2 + 58).m_253046_(60, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"xray.single.close"), button -> this.m_7379_()).m_252794_(this.getWidth() / 2 + 79 + 62, this.getHeight() / 2 + 58).m_253046_(59, 20).m_253136_());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.search.m_93696_() && keyCode == KeyBindings.toggleGui.getKey().m_84873_()) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void updateSearch() {
        if (this.lastSearch.equals(this.search.m_94155_())) {
            return;
        }
        if (this.search.m_94155_().isEmpty()) {
            this.itemList = this.originalList;
            this.scrollList.updateEntries(this.itemList);
            this.lastSearch = "";
            return;
        }
        if (this.search.m_94155_().equals(":on") || this.search.m_94155_().equals(":off")) {
            boolean state = this.search.m_94155_().equals(":on");
            this.itemList = this.originalList.stream().filter(e -> e.isDrawing() == state).collect(Collectors.toCollection(ArrayList::new));
            this.itemList.sort(Comparator.comparingInt(BlockData::getOrder));
            this.scrollList.updateEntries(this.itemList);
            this.lastSearch = this.search.m_94155_();
            return;
        }
        this.itemList = this.originalList.stream().filter(b -> b.getEntryName().toLowerCase().contains(this.search.m_94155_().toLowerCase())).collect(Collectors.toCollection(ArrayList::new));
        this.itemList.sort(Comparator.comparingInt(BlockData::getOrder));
        this.scrollList.updateEntries(this.itemList);
        this.lastSearch = this.search.m_94155_();
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.search != null) {
            this.search.m_94120_();
        }
        this.updateSearch();
    }

    public boolean m_6375_(double x, double y, int mouse) {
        if (this.search.m_6375_(x, y, mouse)) {
            this.m_7522_((GuiEventListener)this.search);
        }
        if (mouse == 1 && this.distButtons.m_5953_(x, y)) {
            Controller.decrementCurrentDist();
            this.distButtons.m_93666_((Component)Component.m_237110_((String)"xray.input.distance", (Object[])new Object[]{Controller.getVisualRadius()}));
            this.distButtons.m_7435_(Minecraft.m_91087_().m_91106_());
        }
        return super.m_6375_(x, y, mouse);
    }

    @Override
    public void renderExtra(GuiGraphics graphics, int x, int y, float partialTicks) {
        this.search.m_88315_(graphics, x, y, partialTicks);
        this.scrollList.m_88315_(graphics, x, y, partialTicks);
        if (!this.search.m_93696_() && this.search.m_94155_().equals("")) {
            graphics.m_280488_(this.getFontRender(), I18n.m_118938_((String)"xray.single.search", (Object[])new Object[0]), this.getWidth() / 2 - 130, this.getHeight() / 2 - 101, Color.GRAY.getRGB());
        }
    }

    public void m_7861_() {
        Configuration.store.radius.save();
        ClientController.blockStore.write(new ArrayList<BlockData>(Controller.getBlockStore().getStore().values()));
        Controller.requestBlockFinder(true);
        super.m_7861_();
    }

    static class ScrollingBlockList
    extends ScrollingList<BlockSlot> {
        static final int SLOT_HEIGHT = 35;
        public GuiSelectionScreen parent;

        ScrollingBlockList(int x, int y, int width, int height, List<BlockData> blocks, GuiSelectionScreen parent) {
            super(x, y, width, height, 35);
            this.updateEntries(blocks);
            this.parent = parent;
        }

        public void setSelected(@Nullable BlockSlot entry, int mouse) {
            if (entry == null) {
                return;
            }
            if (GuiSelectionScreen.m_96638_()) {
                Minecraft.m_91087_().f_91074_.m_6915_();
                Minecraft.m_91087_().m_91152_((Screen)new GuiEdit(entry.block));
                return;
            }
            Controller.getBlockStore().toggleDrawing(entry.block);
            ClientController.blockStore.write(new ArrayList<BlockData>(Controller.getBlockStore().getStore().values()));
        }

        void updateEntries(List<BlockData> blocks) {
            this.m_93516_();
            blocks.forEach(block -> this.m_7085_(new BlockSlot((BlockData)block, this)));
        }

        public static class BlockSlot
        extends AbstractSelectionList.Entry<BlockSlot> {
            BlockData block;
            ScrollingBlockList parent;

            BlockSlot(BlockData block, ScrollingBlockList parent) {
                this.block = block;
                this.parent = parent;
            }

            public BlockData getBlock() {
                return this.block;
            }

            public void m_6311_(GuiGraphics guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
                BlockData blockData = this.block;
                Font font = Minecraft.m_91087_().f_91062_;
                guiGraphics.m_280488_(font, blockData.getEntryName(), left + 35, top + 7, 0xFFFFFF);
                guiGraphics.m_280488_(font, blockData.isDrawing() ? "Enabled" : "Disabled", left + 35, top + 17, blockData.isDrawing() ? Color.GREEN.getRGB() : Color.RED.getRGB());
                guiGraphics.m_280480_(blockData.getItemStack(), left + 8, top + 7);
                guiGraphics.m_280370_(font, blockData.getItemStack(), left + 8, top + 7);
                if (mouseX > left && mouseX < left + entryWidth && mouseY > top && mouseY < top + entryHeight && mouseY < this.parent.getTop() + this.parent.getHeight() && mouseY > this.parent.getTop()) {
                    guiGraphics.m_280245_(font, Language.m_128107_().m_128112_(Arrays.asList(Component.m_237115_((String)"xray.tooltips.edit1"), Component.m_237115_((String)"xray.tooltips.edit2"))), left + 15, entryIdx == this.parent.m_6702_().size() - 1 ? top - (entryHeight - 20) : top + (entryHeight + 15));
                }
                Color color = new Color(blockData.getColor());
                PoseStack stack = guiGraphics.m_280168_();
                stack.m_85836_();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                guiGraphics.m_280163_(CIRCLE, left + entryWidth - 35, (int)((float)top + (float)entryHeight / 2.0f - 9.0f), 0.0f, 0.0f, 14, 14, 14, 14);
                RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
                guiGraphics.m_280163_(CIRCLE, left + entryWidth - 33, (int)((float)top + (float)entryHeight / 2.0f - 7.0f), 0.0f, 0.0f, 10, 10, 10, 10);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                stack.m_85849_();
            }

            public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int mouse) {
                this.parent.setSelected(this, mouse);
                return false;
            }
        }
    }

    static final class SupportButtonInner
    extends SupportButton {
        public SupportButtonInner(int widthIn, int heightIn, int width, int height, String text, String i18nKey, Button.OnPress onPress) {
            super(widthIn, heightIn, width, height, (Component)Component.m_237113_((String)text), Component.m_237115_((String)i18nKey), onPress);
        }
    }
}

