/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.xray.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import pro.mikey.xray.utils.BlockData;

public class BlockStore {
    private HashMap<UUID, BlockData> store = new HashMap();
    private HashMap<String, UUID> storeReference = new HashMap();

    public void put(BlockData data) {
        if (this.storeReference.containsKey(data.getBlockName())) {
            return;
        }
        UUID uniqueId = UUID.randomUUID();
        this.store.put(uniqueId, data);
        this.storeReference.put(data.getBlockName(), uniqueId);
    }

    public void remove(String blockRegistry) {
        if (!this.storeReference.containsKey(blockRegistry)) {
            return;
        }
        UUID uuid = this.storeReference.get(blockRegistry);
        this.storeReference.remove(blockRegistry);
        this.store.remove(uuid);
    }

    public HashMap<UUID, BlockData> getStore() {
        return this.store;
    }

    public void setStore(ArrayList<BlockData> store) {
        this.store.clear();
        this.storeReference.clear();
        store.forEach(this::put);
    }

    public Pair<BlockData, UUID> getStoreByReference(String name) {
        UUID uniqueId = this.storeReference.get(name);
        if (uniqueId == null) {
            return null;
        }
        BlockData blockData = this.store.get(uniqueId);
        if (blockData == null) {
            return null;
        }
        return new ImmutablePair((Object)blockData, (Object)uniqueId);
    }

    public void toggleDrawing(BlockData data) {
        UUID uniqueId = this.storeReference.get(data.getBlockName());
        if (uniqueId == null) {
            return;
        }
        BlockData blockData = this.store.get(uniqueId);
        if (blockData == null) {
            return;
        }
        blockData.setDrawing(!blockData.isDrawing());
    }

    public static ArrayList<BlockData> getFromSimpleBlockList(List<BlockData.SerializableBlockData> simpleList) {
        ArrayList<BlockData> blockData = new ArrayList<BlockData>();
        for (BlockData.SerializableBlockData e : simpleList) {
            Block block;
            if (e == null) continue;
            ResourceLocation location = null;
            try {
                location = new ResourceLocation(e.getBlockName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (location == null || (block = (Block)ForgeRegistries.BLOCKS.getValue(location)) == null) continue;
            blockData.add(new BlockData(e.getName(), e.getBlockName(), e.getColor(), new ItemStack((ItemLike)block, 1), e.isDrawing(), e.getOrder()));
        }
        return blockData;
    }
}

