/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticframes.datagen;

import net.alminoris.aestheticframes.block.ModBlocks;
import net.alminoris.aestheticframes.util.helper.BlockSetsHelper;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "aestheticframes", exFileHelper);
    }

    protected void registerStatesAndModels() {
        Block block;
        this.simpleBlock((Block)ModBlocks.WHITENED_WHITE_TERRACOTTA.get());
        this.blockItem(ModBlocks.WHITENED_WHITE_TERRACOTTA, "block/whitened_white_terracotta");
        for (String name : BlockSetsHelper.getWoods()) {
            for (String frameName : BlockSetsHelper.FRAME_TYPES) {
                block = (Block)ModBlocks.FRAMES.get(frameName + name).get();
                this.registerSimpleStateAndItem(block);
            }
            for (String frameName : BlockSetsHelper.SCALED_FRAME_TYPES) {
                block = (Block)ModBlocks.SCALED_FRAMES.get(frameName + name).get();
                this.registerSimpleStateAndItem(block);
            }
        }
        for (String name : BlockSetsHelper.getStones()) {
            for (String frameName : BlockSetsHelper.FRAME_TYPES) {
                block = (Block)ModBlocks.FRAMES.get(frameName + name).get();
                this.registerSimpleStateAndItem(block);
            }
            for (String frameName : BlockSetsHelper.SCALED_FRAME_TYPES) {
                block = (Block)ModBlocks.SCALED_FRAMES.get(frameName + name).get();
                this.registerSimpleStateAndItem(block);
            }
        }
    }

    private void registerSimpleStateAndItem(Block block) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (id == null) {
            return;
        }
        ModelFile.UncheckedModelFile model = new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"aestheticframes", (String)("block/" + id.m_135815_())));
        this.simpleBlock(block, ConfiguredModel.builder().modelFile((ModelFile)model).build());
        ((ItemModelBuilder)this.itemModels().getBuilder(id.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"aestheticframes", (String)("block/" + id.m_135815_()))));
    }

    private void blockItem(RegistryObject<? extends Block> blockRegistryObject, String name) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile("aestheticframes:" + name));
    }
}

