/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticseating.block;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Supplier;
import net.alminoris.aestheticseating.block.custom.Cushion;
import net.alminoris.aestheticseating.block.custom.SeatingLog;
import net.alminoris.aestheticseating.block.custom.Settee;
import net.alminoris.aestheticseating.block.custom.SimpleBench;
import net.alminoris.aestheticseating.block.custom.SimpleChair;
import net.alminoris.aestheticseating.block.custom.SimpleStool;
import net.alminoris.aestheticseating.block.custom.Sofa;
import net.alminoris.aestheticseating.block.custom.StoneBench;
import net.alminoris.aestheticseating.item.ModItems;
import net.alminoris.aestheticseating.util.helper.BlockSetsHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"aestheticseating");
    public static final Dictionary<String, RegistryObject<Block>> SEATING_LOGS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("seating_log_" + name, () -> new SeatingLog()));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> SIMPLE_CHAIRS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("simple_chair_" + name, () -> new SimpleChair()));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> SIMPLE_BENCHES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("simple_bench_" + name, () -> new SimpleBench(name)));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> STONE_BENCHES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("stone_bench_" + name, () -> new StoneBench()));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> SIMPLE_STOOLS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("simple_stool_" + name, () -> new SimpleStool(name)));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> SETTEES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.COLORS) {
                this.put(name, ModBlocks.registerBlock("settee_" + name, () -> new Settee(name)));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> SOFAS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.COLORS) {
                this.put(name, ModBlocks.registerBlock("sofa_" + name, () -> new Sofa(name)));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> CUSHIONS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.COLORS) {
                this.put(name, ModBlocks.registerBlock("cushion_" + name, () -> new Cushion()));
            }
        }
    };

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

