/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstairs.util.helper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeHelper {
    public static VoxelShape rotateShape(List<AABB> boxes, Direction facing) {
        ArrayList<VoxelShape> rotatedShapes = new ArrayList<VoxelShape>();
        for (AABB originalBox : boxes) {
            double minX = originalBox.f_82288_;
            double minY = originalBox.f_82289_;
            double minZ = originalBox.f_82290_;
            double maxX = originalBox.f_82291_;
            double maxY = originalBox.f_82292_;
            double maxZ = originalBox.f_82293_;
            VoxelShape rotatedShape = switch (facing) {
                case Direction.NORTH -> Shapes.m_83048_((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
                case Direction.SOUTH -> Shapes.m_83048_((double)(1.0 - maxX), (double)minY, (double)(1.0 - maxZ), (double)(1.0 - minX), (double)maxY, (double)(1.0 - minZ));
                case Direction.WEST -> Shapes.m_83048_((double)minZ, (double)minY, (double)(1.0 - maxX), (double)maxZ, (double)maxY, (double)(1.0 - minX));
                case Direction.EAST -> Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX);
                default -> Shapes.m_83048_((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            };
            rotatedShape = VoxelShapeHelper.ensureValidBox(rotatedShape);
            rotatedShapes.add(rotatedShape);
        }
        VoxelShape finalShape = Shapes.m_83040_();
        for (VoxelShape shape : rotatedShapes) {
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)shape);
        }
        return finalShape;
    }

    private static VoxelShape ensureValidBox(VoxelShape shape) {
        AABB box = shape.m_83215_();
        double minX = Math.min(box.f_82288_, box.f_82291_);
        double maxX = Math.max(box.f_82288_, box.f_82291_);
        double minY = Math.min(box.f_82289_, box.f_82292_);
        double maxY = Math.max(box.f_82289_, box.f_82292_);
        double minZ = Math.min(box.f_82290_, box.f_82293_);
        double maxZ = Math.max(box.f_82290_, box.f_82293_);
        return Shapes.m_83048_((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }
}

