/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstorage.block.custom;

import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.alminoris.aestheticstorage.block.entity.HalfcupboardBlockEntity;
import net.alminoris.aestheticstorage.block.entity.ModBlockEntities;
import net.alminoris.aestheticstorage.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class HalfcupboardBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final int MAX_STACK_HEIGHT = 4;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)7.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final BooleanProperty FLIPPED = BooleanProperty.m_61465_((String)"flipped");
    public static final BooleanProperty MANUAL_FLIPPED = BooleanProperty.m_61465_((String)"manual_flipped");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Variant> VARIANT = EnumProperty.m_61587_((String)"variant", Variant.class);

    public HalfcupboardBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)MANUAL_FLIPPED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, VARIANT, OPEN, FLIPPED, MANUAL_FLIPPED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getRotatedShape(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getRotatedShape(state);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        boxes.add(SHAPE.m_83215_());
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HalfcupboardBlockEntity(pos, state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        int countDown;
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Direction facing = ctx.m_8125_();
        boolean waterlogged = level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        int countUp = this.countConnectedCupboards(level, pos.m_7494_(), facing, Direction.UP);
        int totalHeight = countUp + (countDown = this.countConnectedCupboards(level, pos.m_7495_(), facing, Direction.DOWN)) + 1;
        if (totalHeight > 4) {
            return null;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    private int countConnectedCupboards(Level level, BlockPos pos, Direction facing, Direction dir) {
        BlockState state;
        int count = 0;
        while (count < 4 && (state = level.m_8055_(pos)).m_60734_() == this && state.m_61143_((Property)FACING) == facing) {
            ++count;
            pos = pos.m_121945_(dir);
        }
        return count;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return this.updateCupboardVariant(state, level, pos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof HalfcupboardBlockEntity) {
                HalfcupboardBlockEntity cupboard = (HalfcupboardBlockEntity)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)cupboard);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, moved);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!held.m_41619_()) {
            if (held.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aestheticseating", (String)"wrench")))) {
                boolean newFlipped = (Boolean)state.m_61143_((Property)FLIPPED) == false;
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                ArrayList<BlockPos> stack = new ArrayList<BlockPos>();
                HashSet<BlockPos> visited = new HashSet<BlockPos>();
                stack.add(pos);
                while (!stack.isEmpty()) {
                    BlockState currentState;
                    BlockPos current = (BlockPos)stack.remove(stack.size() - 1);
                    if (!visited.add(current) || (currentState = level.m_8055_(current)).m_60734_() != this || currentState.m_61143_((Property)FACING) != facing) continue;
                    BlockState newState = (BlockState)((BlockState)currentState.m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(newFlipped))).m_61124_((Property)MANUAL_FLIPPED, (Comparable)Boolean.valueOf(true));
                    level.m_7731_(current, newState, 3);
                    stack.add(current.m_7494_());
                    stack.add(current.m_7495_());
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        boolean currentOpen = (Boolean)state.m_61143_((Property)OPEN);
        if (currentOpen && !level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof HalfcupboardBlockEntity) {
                HalfcupboardBlockEntity cabinet = (HalfcupboardBlockEntity)blockEntity;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)cabinet, (BlockPos)pos);
            }
        }
        currentOpen = true;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        ArrayList<BlockPos> stack = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        stack.add(pos);
        while (!stack.isEmpty()) {
            BlockState currentState;
            BlockPos current = (BlockPos)stack.remove(stack.size() - 1);
            if (!visited.add(current) || (currentState = level.m_8055_(current)).m_60734_() != this || currentState.m_61143_((Property)FACING) != facing) continue;
            Variant variant = (Variant)((Object)currentState.m_61143_(VARIANT));
            if (variant == Variant.UP || variant == Variant.DOWN || variant == Variant.CENTER) {
                level.m_7731_(current, (BlockState)currentState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(currentOpen)), 3);
                stack.add(current.m_7494_());
                stack.add(current.m_7495_());
                continue;
            }
            if (variant != Variant.NORMAL) continue;
            level.m_7731_(current, (BlockState)currentState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(currentOpen)), 3);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return HalfcupboardBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.HALFCUPBOARD_BLOCK_ENTITY.get()), (lvl, pos, st, be) -> be.tick(lvl, pos, st));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        this.updateSurroundingVerticalCupboards(level, pos);
    }

    private void updateSurroundingVerticalCupboards(Level level, BlockPos pos) {
        for (Direction dir : new Direction[]{Direction.UP, Direction.DOWN}) {
            BlockPos neighborPos = pos.m_121945_(dir);
            BlockState neighborState = level.m_8055_(neighborPos);
            if (neighborState.m_60734_() != this) continue;
            level.m_7731_(neighborPos, this.updateCupboardVariant(neighborState, (LevelAccessor)level, neighborPos), 3);
        }
    }

    private BlockState updateCupboardVariant(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos up = pos.m_7494_();
        BlockPos down = pos.m_7495_();
        boolean upConnected = this.isCupboard(level, up, facing);
        boolean downConnected = this.isCupboard(level, down, facing);
        Variant variant = Variant.NORMAL;
        if (upConnected && downConnected) {
            variant = Variant.CENTER;
        } else if (upConnected) {
            variant = Variant.DOWN;
        } else if (downConnected) {
            variant = Variant.UP;
        }
        BlockPos leftPos = pos.m_121945_(facing.m_122427_());
        boolean autoFlipped = this.isCupboard(level, leftPos, facing);
        boolean manual = (Boolean)state.m_61143_((Property)MANUAL_FLIPPED);
        boolean flipped = manual ? (Boolean)state.m_61143_((Property)FLIPPED) : autoFlipped;
        return (BlockState)((BlockState)((BlockState)state.m_61124_(VARIANT, (Comparable)((Object)variant))).m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(flipped))).m_61124_((Property)MANUAL_FLIPPED, (Comparable)Boolean.valueOf(manual));
    }

    private boolean isCupboard(LevelAccessor level, BlockPos pos, Direction facing) {
        BlockState state = level.m_8055_(pos);
        return state.m_60734_() == this && state.m_61143_((Property)FACING) == facing;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        CENTER("center"),
        UP("up"),
        DOWN("down");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

