/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticstorage.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import net.alminoris.aestheticstorage.block.ModBlocks;
import net.alminoris.aestheticstorage.block.entity.CabinetBlockEntity;
import net.alminoris.aestheticstorage.menu.CabinetMenu;
import net.alminoris.aestheticstorage.util.helper.BlockSetsHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class CabinetScreen
extends AbstractContainerScreen<CabinetMenu> {
    private final String NAME;
    private final ResourceLocation TEXTURE;

    public CabinetScreen(CabinetMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        Block block;
        Container container = ((CabinetMenu)this.f_97732_).m_38853_((int)0).f_40218_;
        if (container instanceof CabinetBlockEntity) {
            CabinetBlockEntity be = (CabinetBlockEntity)container;
            block = be.m_58904_().m_8055_(be.m_58899_()).m_60734_();
        } else {
            block = null;
        }
        this.NAME = BuiltInRegistries.f_256975_.m_7981_((Object)Objects.requireNonNull(block)).m_135815_();
        this.TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aestheticstorage", (String)("textures/gui/" + this.getWoodName() + ".png"));
    }

    private String getWoodName() {
        Block block;
        Container container = ((CabinetMenu)this.f_97732_).m_38853_((int)0).f_40218_;
        if (container instanceof CabinetBlockEntity) {
            CabinetBlockEntity be = (CabinetBlockEntity)container;
            block = be.m_58904_().m_8055_(be.m_58899_()).m_60734_();
        } else {
            block = null;
        }
        Block block2 = Objects.requireNonNull(block);
        String value = CabinetScreen.getKeyByValue((Hashtable)ModBlocks.CABINETS, block2);
        if (value != null) {
            return value;
        }
        value = CabinetScreen.getKeyByValue((Hashtable)ModBlocks.FLIPDOWN_CABINETS, block2);
        if (value != null) {
            return value;
        }
        value = CabinetScreen.getKeyByValue((Hashtable)ModBlocks.FLIPUP_CABINETS, block2);
        if (value != null) {
            return value;
        }
        return "";
    }

    private static String getKeyByValue(Hashtable<String, RegistryObject<Block>> table, Block value) {
        for (Map.Entry<String, RegistryObject<Block>> entry : table.entrySet()) {
            if (!((Block)entry.getValue().get()).equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97729_ = 10;
        this.f_97728_ = 10;
        this.f_97730_ = 10;
        this.f_97731_ = 68;
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        int color = 0xFFFFFF;
        for (String name : BlockSetsHelper.getWoods()) {
            if (!this.NAME.endsWith("_" + name)) continue;
            color = BlockSetsHelper.WOOD_COLORS.get(name);
        }
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, color, false);
        graphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, color, false);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(this.TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }
}

