/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aesthetictables.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ExtraTable
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LEG1 = BooleanProperty.m_61465_((String)"leg1");
    public static final BooleanProperty LEG2 = BooleanProperty.m_61465_((String)"leg2");
    public static final BooleanProperty LEG3 = BooleanProperty.m_61465_((String)"leg3");
    public static final BooleanProperty LEG4 = BooleanProperty.m_61465_((String)"leg4");
    public static final BooleanProperty SINGLE = BooleanProperty.m_61465_((String)"single");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)13.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape DEFAULT_LEG = Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)14.0, (double)10.5);
    protected static final VoxelShape LEG_1 = Block.m_49796_((double)9.5, (double)0.0, (double)1.5, (double)14.5, (double)13.5, (double)6.5);
    protected static final VoxelShape LEG_2 = Block.m_49796_((double)9.5, (double)0.0, (double)9.5, (double)14.5, (double)13.5, (double)14.5);
    protected static final VoxelShape LEG_3 = Block.m_49796_((double)1.5, (double)0.0, (double)9.5, (double)6.5, (double)13.5, (double)14.5);
    protected static final VoxelShape LEG_4 = Block.m_49796_((double)1.5, (double)0.0, (double)1.5, (double)6.5, (double)13.5, (double)6.5);

    public ExtraTable(BlockBehaviour.Properties settings) {
        super(settings.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LEG1, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEG2, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEG3, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEG4, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SINGLE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LEG1, LEG2, LEG3, LEG4, SINGLE, WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean waterlogged = ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_;
        return this.getUpdatedLegs((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), (LevelAccessor)ctx.m_43725_(), ctx.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return this.getUpdatedLegs(state, world, pos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    private BlockState getUpdatedLegs(BlockState state, LevelAccessor world, BlockPos pos) {
        boolean leg4;
        boolean north = this.connectsTo(world, pos.m_122012_());
        boolean east = this.connectsTo(world, pos.m_122029_());
        boolean south = this.connectsTo(world, pos.m_122019_());
        boolean west = this.connectsTo(world, pos.m_122024_());
        boolean ne = this.connectsTo(world, pos.m_122012_().m_122029_());
        boolean se = this.connectsTo(world, pos.m_122019_().m_122029_());
        boolean sw = this.connectsTo(world, pos.m_122019_().m_122024_());
        boolean nw = this.connectsTo(world, pos.m_122012_().m_122024_());
        boolean leg1 = !north && !east || north && east && !ne;
        boolean leg2 = !east && !south || east && south && !se;
        boolean leg3 = !south && !west || south && west && !sw;
        boolean bl = leg4 = !north && !west || north && west && !nw;
        if (leg1 && leg2 && leg3 && leg4) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)LEG1, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEG2, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEG3, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEG4, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SINGLE, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)LEG1, (Comparable)Boolean.valueOf(leg1))).m_61124_((Property)LEG2, (Comparable)Boolean.valueOf(leg2))).m_61124_((Property)LEG3, (Comparable)Boolean.valueOf(leg3))).m_61124_((Property)LEG4, (Comparable)Boolean.valueOf(leg4))).m_61124_((Property)SINGLE, (Comparable)Boolean.valueOf(false));
    }

    private boolean connectsTo(LevelAccessor world, BlockPos pos) {
        BlockState neighbor = world.m_8055_(pos);
        return neighbor.m_60734_() == this;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ctx) {
        VoxelShape shape = TOP;
        if (((Boolean)state.m_61143_((Property)LEG1)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)LEG_1);
        }
        if (((Boolean)state.m_61143_((Property)LEG2)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)LEG_2);
        }
        if (((Boolean)state.m_61143_((Property)LEG3)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)LEG_3);
        }
        if (((Boolean)state.m_61143_((Property)LEG4)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)LEG_4);
        }
        if (((Boolean)state.m_61143_((Property)LEG1)).booleanValue() && ((Boolean)state.m_61143_((Property)LEG2)).booleanValue() && ((Boolean)state.m_61143_((Property)LEG3)).booleanValue() && ((Boolean)state.m_61143_((Property)LEG4)).booleanValue() || ((Boolean)state.m_61143_((Property)SINGLE)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DEFAULT_LEG);
        }
        return shape;
    }
}

