/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticwindows.block.custom;

import java.util.ArrayList;
import java.util.HashSet;
import net.alminoris.aestheticwindows.block.custom.YAxisRotatedBlock;
import net.alminoris.aestheticwindows.sound.ModSounds;
import net.alminoris.aestheticwindows.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BaseWindowVerticalBlock
extends YAxisRotatedBlock {
    protected static final VoxelShape SHAPE = BaseWindowVerticalBlock.m_49796_((double)0.0, (double)0.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5);
    protected static final VoxelShape UP = BaseWindowVerticalBlock.m_49796_((double)1.0, (double)15.0, (double)6.5, (double)15.0, (double)16.0, (double)9.5);
    protected static final VoxelShape DOWN = BaseWindowVerticalBlock.m_49796_((double)1.0, (double)0.0, (double)6.5, (double)15.0, (double)1.0, (double)9.5);
    protected static final VoxelShape LEFT = BaseWindowVerticalBlock.m_49796_((double)0.0, (double)0.0, (double)6.5, (double)1.0, (double)16.0, (double)9.5);
    protected static final VoxelShape RIGHT = BaseWindowVerticalBlock.m_49796_((double)15.0, (double)0.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5);
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final BooleanProperty FLIPPED = BooleanProperty.m_61465_((String)"flipped");
    public static final EnumProperty<Variant> VARIANT = EnumProperty.m_61587_((String)"variant", Variant.class);

    public BaseWindowVerticalBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VARIANT, OPEN, FLIPPED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    protected VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            switch ((Variant)((Object)state.m_61143_(VARIANT))) {
                case NORMAL: {
                    boxes.add(UP.m_83215_());
                    boxes.add(DOWN.m_83215_());
                    break;
                }
                case UP: {
                    boxes.add(UP.m_83215_());
                    break;
                }
                case DOWN: {
                    boxes.add(DOWN.m_83215_());
                }
            }
            boxes.add(LEFT.m_83215_());
            boxes.add(RIGHT.m_83215_());
        } else {
            boxes.add(SHAPE.m_83215_());
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_21205_().m_41619_()) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            this.playSound(world, player, (SoundEvent)ModSounds.OPEN_WINDOW.get(), 1.0f, 1.0f);
        } else {
            this.playSound(world, player, (SoundEvent)ModSounds.CLOSE_WINDOW.get(), 1.0f, 1.0f);
        }
        boolean newOpen = (Boolean)state.m_61143_((Property)OPEN) == false;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        ArrayList<BlockPos> stack = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        stack.add(pos);
        while (!stack.isEmpty()) {
            BlockState currentState;
            BlockPos currentPos = (BlockPos)stack.remove(stack.size() - 1);
            if (!visited.add(currentPos) || !((currentState = world.m_8055_(currentPos)).m_60734_() instanceof BaseWindowVerticalBlock) || currentState.m_61143_((Property)FACING) != facing) continue;
            Variant currentVariant = (Variant)((Object)currentState.m_61143_(VARIANT));
            if (currentVariant == Variant.UP || currentVariant == Variant.DOWN || currentVariant == Variant.CENTER) {
                world.m_7731_(currentPos, (BlockState)currentState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(newOpen)), 3);
                stack.add(currentPos.m_7494_());
                stack.add(currentPos.m_7495_());
                continue;
            }
            if (currentVariant != Variant.NORMAL) continue;
            world.m_7731_(currentPos, (BlockState)currentState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(newOpen)), 3);
        }
        return InteractionResult.SUCCESS;
    }

    private void playSound(Level world, Player player, SoundEvent sound, float volume, float pitch) {
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, player.m_5720_(), volume, pitch);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
        return this.updateVerticalWindowVariant(state, world, pos);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.m_6807_(state, world, pos, oldState, notify);
        this.updateSurroundingVerticalWindows(world, pos);
    }

    private void updateSurroundingVerticalWindows(Level world, BlockPos pos) {
        for (Direction direction : new Direction[]{Direction.UP, Direction.DOWN}) {
            BlockPos neighborPos = pos.m_121955_(direction.m_122436_());
            BlockState neighborState = world.m_8055_(neighborPos);
            if (!(neighborState.m_60734_() instanceof BaseWindowVerticalBlock)) continue;
            world.m_7731_(neighborPos, this.updateVerticalWindowVariant(neighborState, (LevelAccessor)world, neighborPos), 3);
        }
    }

    private BlockState updateVerticalWindowVariant(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos upPos = pos.m_7494_();
        BlockPos downPos = pos.m_7495_();
        boolean upConnected = this.isWindow(world, upPos, facing);
        boolean downConnected = this.isWindow(world, downPos, facing);
        Variant variant = Variant.NORMAL;
        if (upConnected && downConnected) {
            variant = Variant.CENTER;
        } else if (upConnected) {
            variant = Variant.DOWN;
        } else if (downConnected) {
            variant = Variant.UP;
        }
        BlockPos leftPos = pos.m_121955_(facing.m_175362_(Direction.Axis.Y).m_122436_());
        boolean flipped = this.isWindow(world, leftPos, facing);
        return (BlockState)((BlockState)state.m_61124_(VARIANT, (Comparable)((Object)variant))).m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(flipped));
    }

    private boolean isWindow(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof BaseWindowVerticalBlock && state.m_61143_((Property)FACING) == facing;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        CENTER("center"),
        UP("up"),
        DOWN("down");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

