/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.graph;

import com.google.common.collect.ImmutableList;
import com.kipti.bnb.content.cogwheel_chain.graph.ChainInteractionFailedException;
import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChainGeometryBuilder;
import com.kipti.bnb.content.cogwheel_chain.graph.PathedCogwheelNode;
import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelChain;
import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.createmod.catnip.data.Pair;
import net.minecraft.world.phys.Vec3;

public class CogwheelChainPathfinder {
    public static List<PathedCogwheelNode> buildChainPath(PlacingCogwheelChain worldSpaceChain) throws ChainInteractionFailedException {
        PartialPathFrontierData finalPath;
        PlacingCogwheelChain chain = worldSpaceChain.toLocalSpaceChain();
        AtomicReference<PartialPathFrontierData> leftPath = new AtomicReference<PartialPathFrontierData>(new PartialPathFrontierData((ImmutableList<PathedCogwheelNode>)ImmutableList.of((Object)new PathedCogwheelNode(chain.getNodes().get(0), 1)), 0.0, 0));
        AtomicReference<PartialPathFrontierData> rightPath = new AtomicReference<PartialPathFrontierData>(new PartialPathFrontierData((ImmutableList<PathedCogwheelNode>)ImmutableList.of((Object)new PathedCogwheelNode(chain.getNodes().get(0), -1)), 0.0, 0));
        PlacingCogwheelNode prevNode = chain.getNodes().get(0);
        for (int i = 1; i < chain.getNodes().size() * 2; ++i) {
            PlacingCogwheelNode nextNode = chain.getNodes().get(i % chain.getNodes().size());
            PlacingCogwheelNode nextNextNode = chain.getNodes().get((i + 1) % chain.getNodes().size());
            AtomicReference<Object> nextLeftPath = new AtomicReference<Object>(null);
            AtomicReference<Object> nextRightPath = new AtomicReference<Object>(null);
            for (Pair pathChannel : List.of(Pair.of(leftPath, (Object)1), Pair.of(rightPath, (Object)-1))) {
                AtomicReference fromPath = (AtomicReference)pathChannel.getFirst();
                if (fromPath.get() == null) continue;
                int fromSide = (Integer)pathChannel.getSecond();
                for (int toSide = 1; toSide >= -1; toSide -= 2) {
                    if (!CogwheelChainPathfinder.isValidPathStep(prevNode, fromSide, nextNode, toSide)) continue;
                    CogwheelChainPathfinder.stepPathfinding(prevNode, nextNode, fromSide, toSide, fromPath, nextNextNode, nextLeftPath, nextRightPath, chain.getSize());
                }
            }
            leftPath = nextLeftPath;
            rightPath = nextRightPath;
            if (leftPath.get() == null && rightPath.get() == null) {
                throw new ChainInteractionFailedException("pathfinding_failed_at_node");
            }
            prevNode = nextNode;
        }
        PartialPathFrontierData partialPathFrontierData = leftPath.get() != null && rightPath.get() != null ? leftPath.get().compare(rightPath.get()) : (finalPath = leftPath.get() != null ? leftPath.get() : rightPath.get());
        if (finalPath == null) {
            return null;
        }
        ArrayList<PathedCogwheelNode> finalTraversed = new ArrayList<PathedCogwheelNode>((Collection<PathedCogwheelNode>)finalPath.traversed);
        finalTraversed.remove(finalTraversed.size() - 1);
        for (int i = 0; i < chain.getNodes().size() - 1; ++i) {
            finalTraversed.remove(0);
        }
        return finalTraversed;
    }

    private static void stepPathfinding(PlacingCogwheelNode prevNode, PlacingCogwheelNode nextNode, int fromSide, int toSide, AtomicReference<PartialPathFrontierData> fromPath, PlacingCogwheelNode nextNextNode, AtomicReference<PartialPathFrontierData> nextLeftPath, AtomicReference<PartialPathFrontierData> nextRightPath, int size) {
        AtomicReference<PartialPathFrontierData> targetPath;
        Vec3 fromPos = prevNode.center().m_82549_(CogwheelChainPathfinder.getPathingTangentOnCog(nextNode, prevNode, -fromSide));
        Vec3 toPos = nextNode.center().m_82549_(CogwheelChainPathfinder.getPathingTangentOnCog(prevNode, nextNode, toSide));
        ImmutableList<PathedCogwheelNode> traversed = fromPath.get().traversed;
        int traversedSize = traversed.size();
        double distance = fromPos.m_82554_(toPos) + CogwheelChainPathfinder.getArcDistanceOnCog(new PathedCogwheelNode(prevNode, fromSide), new PathedCogwheelNode(nextNode, toSide), new PathedCogwheelNode(nextNextNode, CogwheelChainPathfinder.isValidPathStep(nextNode, toSide, nextNextNode, toSide) ? toSide : -toSide)) * 10.0;
        int selfIntersections = nextNextNode == prevNode ? (toSide != fromSide ? 1 : 0) : (traversedSize < 2 ? 0 : CogwheelChainPathfinder.getSelfIntersection((PathedCogwheelNode)traversed.get(traversedSize - 2), (PathedCogwheelNode)traversed.get(traversedSize - 1), nextNode, toSide));
        PartialPathFrontierData extendedPath = fromPath.get().extend(new PathedCogwheelNode(nextNode, toSide), distance, selfIntersections);
        AtomicReference<PartialPathFrontierData> atomicReference = targetPath = toSide == 1 ? nextLeftPath : nextRightPath;
        if (targetPath.get() == null) {
            targetPath.set(extendedPath);
        } else {
            targetPath.set(targetPath.get().compare(extendedPath));
        }
    }

    private static double getArcDistanceOnCog(PathedCogwheelNode prevNode, PathedCogwheelNode currentNode, PathedCogwheelNode nextNode) {
        Vec3 fromTangent = CogwheelChainGeometryBuilder.getTangentPointOnCircle(prevNode, currentNode, true);
        Vec3 toTangent = CogwheelChainGeometryBuilder.getTangentPointOnCircle(nextNode, currentNode, false);
        Vec3 incomingDiff = currentNode.center().m_82546_(prevNode.center());
        if (toTangent.m_82557_(fromTangent) < 1.0E-4) {
            return 0.0;
        }
        if (incomingDiff.m_82541_().m_82526_(toTangent.m_82546_(fromTangent)) < 0.0) {
            return 0.0;
        }
        double angle = Math.acos(Math.max(-1.0, Math.min(1.0, fromTangent.m_82541_().m_82526_(toTangent.m_82541_()))));
        double radius = currentNode.isLarge() ? 1.0 : 0.5;
        return angle * radius;
    }

    public static int getSelfIntersection(PathedCogwheelNode from, PathedCogwheelNode middle, PlacingCogwheelNode to, int side) {
        if (from.rotationAxis() != to.rotationAxis() || middle.rotationAxis() != to.rotationAxis()) {
            return 0;
        }
        Vec3 prevFromPathPos = CogwheelChainPathfinder.getPathingTangentOnCog(middle, from, -from.side()).m_82549_(from.center());
        Vec3 prevToPathPos = CogwheelChainPathfinder.getPathingTangentOnCog(from, middle, middle.side()).m_82549_(middle.center());
        Vec3 nextFromPathPos = CogwheelChainPathfinder.getPathingTangentOnCog(to, middle, -middle.side()).m_82549_(middle.center());
        Vec3 nextToPathPos = CogwheelChainPathfinder.getPathingTangentOnCog(middle, to, side).m_82549_(to.center());
        return CogwheelChainPathfinder.doLinesIntersectOnPlane(middle.rotationAxisVec(), prevFromPathPos.m_82546_(middle.center()), prevToPathPos.m_82546_(middle.center()), nextFromPathPos.m_82546_(middle.center()), nextToPathPos.m_82546_(middle.center())) ? 1 : 0;
    }

    private static boolean doLinesIntersectOnPlane(Vec3 axis, Vec3 fromStart, Vec3 fromEndWhichIsAroundCenter, Vec3 toStartWhichIsAroundCenter, Vec3 toEnd) {
        Vec3 fromDir = fromEndWhichIsAroundCenter.m_82546_(fromStart);
        Vec3 toDir = toEnd.m_82546_(toStartWhichIsAroundCenter);
        Vec3 normal = axis;
        Vec3 diff = toStartWhichIsAroundCenter.m_82546_(fromStart);
        double denom = normal.m_82526_(fromDir.m_82537_(toDir));
        if (Math.abs(denom) < 1.0E-7) {
            return false;
        }
        double t = normal.m_82526_(diff.m_82537_(toDir)) / denom;
        double u = normal.m_82526_(diff.m_82537_(fromDir)) / denom;
        return t >= 0.0 && t <= 1.0 && u >= 0.0 && u <= 1.0;
    }

    public static boolean isValidPathStep(PlacingCogwheelNode from, int fromSide, PlacingCogwheelNode to, int toSide) {
        if (from.rotationAxis() == to.rotationAxis()) {
            return true;
        }
        if (!from.isLarge() || !to.isLarge()) {
            return false;
        }
        Vec3 diff = to.center().m_82546_(from.center());
        Vec3 sideAxis = to.rotationAxisVec();
        Vec3 upAxis = from.rotationAxisVec();
        Vec3 fromTangentOffset = CogwheelChainPathfinder.getPathingTangentOnCog(to, from, -fromSide);
        Vec3 toTangentOffset = CogwheelChainPathfinder.getPathingTangentOnCog(from, to, toSide);
        return sideAxis.m_82559_(diff).m_82526_(fromTangentOffset) == 1.0 && upAxis.m_82559_(diff).m_82526_(toTangentOffset) == -1.0;
    }

    public static List<Integer> getValidPathSteps(PlacingCogwheelNode lastNode, PlacingCogwheelNode newNode) {
        ArrayList<Integer> validSides = new ArrayList<Integer>();
        for (int side = 1; side >= -1; side -= 2) {
            if (!CogwheelChainPathfinder.isValidPathStep(lastNode, side, newNode, 1) && !CogwheelChainPathfinder.isValidPathStep(lastNode, side, newNode, -1)) continue;
            validSides.add(side);
        }
        return validSides;
    }

    public static Vec3 getPathingTangentOnCog(PathedCogwheelNode from, PathedCogwheelNode to, int toSide) {
        return CogwheelChainPathfinder.getPathingTangentOnCog(from.center(), from.rotationAxisVec(), to.center(), to.isLarge(), to.rotationAxisVec(), toSide);
    }

    public static Vec3 getPathingTangentOnCog(PathedCogwheelNode from, PlacingCogwheelNode to, int toSide) {
        return CogwheelChainPathfinder.getPathingTangentOnCog(from.center(), from.rotationAxisVec(), to.center(), to.isLarge(), to.rotationAxisVec(), toSide);
    }

    public static Vec3 getPathingTangentOnCog(PlacingCogwheelNode from, PathedCogwheelNode to, int toSide) {
        return CogwheelChainPathfinder.getPathingTangentOnCog(from.center(), from.rotationAxisVec(), to.center(), to.isLarge(), to.rotationAxisVec(), toSide);
    }

    public static Vec3 getPathingTangentOnCog(PlacingCogwheelNode from, PlacingCogwheelNode to, int toSide) {
        return CogwheelChainPathfinder.getPathingTangentOnCog(from.center(), from.rotationAxisVec(), to.center(), to.isLarge(), to.rotationAxisVec(), toSide);
    }

    public static Vec3 getPathingTangentOnCog(Vec3 fromCenter, Vec3 fromRotationAxis, Vec3 toCenter, boolean toLarge, Vec3 toRotationAxis, int toSide) {
        double toRadius = toLarge ? 1.0 : 0.5;
        Vec3 differenceTo = toCenter.m_82546_(fromCenter);
        if (!fromRotationAxis.equals((Object)toRotationAxis)) {
            differenceTo = CogwheelChainPathfinder.projectDirToAxisPlane(CogwheelChainPathfinder.projectDirToAxisPlane(differenceTo, toRotationAxis), fromRotationAxis);
        }
        return toRotationAxis.m_82537_(differenceTo).m_82541_().m_82490_((double)toSide * toRadius);
    }

    public static Vec3 projectDirToAxisPlane(Vec3 vec, Vec3 axisVec) {
        return vec.m_82546_(axisVec.m_82559_(vec));
    }

    public record PartialPathFrontierData(ImmutableList<PathedCogwheelNode> traversed, double distance, int chainIntersections) {
        public PartialPathFrontierData compare(PartialPathFrontierData other) {
            if (this.chainIntersections != other.chainIntersections) {
                return this.chainIntersections < other.chainIntersections ? this : other;
            }
            return this.distance > other.distance ? this : other;
        }

        public PartialPathFrontierData extend(PathedCogwheelNode nextNode, double additionalDistance, int additionalSelfIntersections) {
            ArrayList<PathedCogwheelNode> newTraversed = new ArrayList<PathedCogwheelNode>((Collection<PathedCogwheelNode>)this.traversed);
            newTraversed.add(nextNode);
            return new PartialPathFrontierData((ImmutableList<PathedCogwheelNode>)ImmutableList.copyOf(newTraversed), this.distance + additionalDistance, this.chainIntersections + additionalSelfIntersections);
        }
    }
}

