/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.graph;

import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

public record PathedCogwheelNode(int side, boolean isLarge, Direction.Axis rotationAxis, BlockPos localPos, boolean offsetForSmallCogwheel) {
    public PathedCogwheelNode(PlacingCogwheelNode partialNode, int side) {
        this(side, partialNode.isLarge(), partialNode.rotationAxis(), partialNode.pos(), partialNode.hasOffsetForSmallCogwheel());
    }

    public void write(CompoundTag nodeTag) {
        nodeTag.m_128379_("Side", this.side == 1);
        nodeTag.m_128379_("IsLarge", this.isLarge);
        nodeTag.m_128379_("OffsetForSmallCogwheel", this.offsetForSmallCogwheel);
        nodeTag.m_128405_("OffsetX", this.localPos.m_123341_());
        nodeTag.m_128405_("OffsetY", this.localPos.m_123342_());
        nodeTag.m_128405_("OffsetZ", this.localPos.m_123343_());
        nodeTag.m_128405_("RotationAxis", this.rotationAxis.ordinal());
    }

    public static PathedCogwheelNode read(CompoundTag nodeTag) {
        int side = nodeTag.m_128471_("Side") ? 1 : -1;
        boolean isLarge = nodeTag.m_128471_("IsLarge");
        BlockPos offset = new BlockPos(nodeTag.m_128451_("OffsetX"), nodeTag.m_128451_("OffsetY"), nodeTag.m_128451_("OffsetZ"));
        Direction.Axis rotationAxis = Direction.Axis.values()[nodeTag.m_128451_("RotationAxis")];
        boolean offsetForSmallCogwheel = nodeTag.m_128441_("OffsetForSmallCogwheel") ? nodeTag.m_128471_("OffsetForSmallCogwheel") : !isLarge;
        return new PathedCogwheelNode(side, isLarge, rotationAxis, offset, offsetForSmallCogwheel);
    }

    public float sideFactor() {
        return (float)this.side * (this.isLarge ? 1.0f : 0.5f);
    }

    public Vec3 center() {
        return this.localPos.m_252807_();
    }

    public Vec3 rotationAxisVec() {
        switch (this.rotationAxis) {
            case X: {
                return new Vec3(1.0, 0.0, 0.0);
            }
            case Y: {
                return new Vec3(0.0, 1.0, 0.0);
            }
            case Z: {
                return new Vec3(0.0, 0.0, 1.0);
            }
        }
        return Vec3.f_82478_;
    }
}

