/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut;

import com.kipti.bnb.content.girder_strut.GirderStrutBlockEntity;
import com.kipti.bnb.content.girder_strut.StrutModelType;
import com.kipti.bnb.registry.BnbBlockEntities;
import com.kipti.bnb.registry.BnbShapes;
import com.simibubi.create.foundation.block.IBE;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GirderStrutBlock
extends Block
implements IBE<GirderStrutBlockEntity>,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final int MAX_SPAN = 8;
    private StrutModelType modelType;

    public GirderStrutBlock(BlockBehaviour.Properties properties, StrutModelType modelType) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        this.modelType = modelType;
    }

    public static NonNullFunction<BlockBehaviour.Properties, GirderStrutBlock> normal() {
        return properties -> new GirderStrutBlock((BlockBehaviour.Properties)properties, StrutModelType.NORMAL);
    }

    public static NonNullFunction<BlockBehaviour.Properties, GirderStrutBlock> weathered() {
        return properties -> new GirderStrutBlock((BlockBehaviour.Properties)properties, StrutModelType.WEATHERED);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction direction, @NotNull BlockState neighbourState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighbourPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BlockStateProperties.f_61362_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState ifluidstate = level.m_6425_(pos);
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return BnbShapes.GIRDER_STRUT.get((Direction)state.m_61143_((Property)FACING));
    }

    public PushReaction getPistonPushReaction(@NotNull BlockState state) {
        return PushReaction.NORMAL;
    }

    public void m_5707_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, Player player) {
        boolean shouldPreventDrops = player.m_7500_();
        if (shouldPreventDrops && !level.f_46443_) {
            this.destroyConnectedStrut(level, pos, false);
        }
        super.m_5707_(level, pos, state, player);
    }

    private void destroyConnectedStrut(Level level, BlockPos pos, boolean dropBlock) {
        this.withBlockEntityDo((BlockGetter)level, pos, gbe -> {
            for (BlockPos otherPos : gbe.getConnectionsCopy()) {
                BlockEntity otherBe = level.m_7702_(otherPos = otherPos.m_121955_((Vec3i)pos));
                if (!(otherBe instanceof GirderStrutBlockEntity)) continue;
                GirderStrutBlockEntity other = (GirderStrutBlockEntity)otherBe;
                other.removeConnection(pos);
                if (other.connectionCount() != 0) continue;
                level.m_46961_(otherPos, dropBlock);
            }
        });
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_()) && !level.f_46443_) {
            this.destroyConnectedStrut(level, pos, true);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public Class<GirderStrutBlockEntity> getBlockEntityClass() {
        return GirderStrutBlockEntity.class;
    }

    public BlockEntityType<? extends GirderStrutBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BnbBlockEntities.GIRDER_STRUT.get();
    }

    public StrutModelType getModelType() {
        return this.modelType;
    }

    public void setModelType(StrutModelType modelType) {
        this.modelType = modelType;
    }
}

