/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut;

import com.kipti.bnb.content.girder_strut.GirderStrutBlock;
import com.kipti.bnb.content.girder_strut.GirderStrutBlockEntity;
import com.kipti.bnb.content.girder_strut.GirderStrutModelBuilder;
import com.kipti.bnb.content.girder_strut.GirderStrutModelManipulator;
import com.kipti.bnb.content.girder_strut.StrutModelType;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperBufferFactory;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class GirderStrutBlockEntityRenderer
extends SmartBlockEntityRenderer<GirderStrutBlockEntity> {
    public GirderStrutBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(GirderStrutBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)blockEntity, partialTicks, ms, buffer, light, overlay);
        Block block = blockEntity.m_58900_().m_60734_();
        if (!(block instanceof GirderStrutBlock)) {
            return;
        }
        GirderStrutBlock girderStrutBlock = (GirderStrutBlock)block;
        StrutModelType modelType = girderStrutBlock.getModelType();
        if (Minecraft.m_91087_().f_91066_.m_232060_().m_231551_() == GraphicsStatus.FAST) {
            for (BlockPos pos : blockEntity.getConnectionsCopy()) {
                pos = pos.m_121955_((Vec3i)blockEntity.m_58899_());
                BlockState state = blockEntity.m_58904_().m_8055_(pos);
                if (!(state.m_60734_() instanceof GirderStrutBlock)) continue;
                BlockPos relative = pos.m_121996_((Vec3i)blockEntity.m_58899_());
                Vec3 thisAttachment = Vec3.m_82512_((Vec3i)blockEntity.m_58899_()).m_231075_((Direction)blockEntity.m_58900_().m_61143_((Property)GirderStrutBlock.FACING), -0.4);
                BlockState otherState = blockEntity.m_58904_().m_8055_(pos);
                Vec3 otherAttachment = Vec3.m_82512_((Vec3i)pos).m_231075_((Direction)otherState.m_61143_((Property)GirderStrutBlock.FACING), -0.4);
                double length = thisAttachment.m_82554_(otherAttachment);
                int segments = (int)Math.ceil(length);
                double lengthOffset = (length - (double)segments) / 2.0;
                ms.m_85836_();
                Vec3 relativeVec = otherAttachment.m_82546_(thisAttachment);
                float distHorizontal = (float)Math.sqrt(relativeVec.m_7096_() * relativeVec.m_7096_() + relativeVec.m_7094_() * relativeVec.m_7094_());
                double yRot = distHorizontal == 0.0f ? 0.0 : Math.atan2(relativeVec.m_7096_(), relativeVec.m_7094_());
                double xRot = (float)Math.atan2(relativeVec.m_7098_(), distHorizontal);
                ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).translate(Vec3.m_82528_((Vec3i)((Direction)blockEntity.m_58900_().m_61143_((Property)GirderStrutBlock.FACING)).m_122436_()).m_82490_(-0.4))).center()).rotateY((float)yRot)).rotateX(-((float)xRot))).uncenter();
                ms.m_85837_(0.0, 0.0, lengthOffset + 0.5);
                if (this.getRenderPriority((Vec3i)relative) > this.getRenderPriority(relative.m_142393_(-1))) {
                    this.renderSegments(state, modelType.getPartialModel(), ms, segments, buffer, blockEntity.m_58904_() == null ? light : LevelRenderer.m_109541_((BlockAndTintGetter)blockEntity.m_58904_(), (BlockPos)pos));
                }
                ms.m_85849_();
            }
        } else {
            if (blockEntity.connectionRenderBufferCache == null) {
                GirderStrutModelBuilder.GirderStrutModelData connectionData = GirderStrutModelBuilder.GirderStrutModelData.collect((BlockAndTintGetter)blockEntity.m_58904_(), blockEntity.m_58899_(), blockEntity.m_58900_(), blockEntity);
                List quads = connectionData.connections().stream().flatMap(c -> GirderStrutModelManipulator.bakeConnectionToConsumer(c, modelType, blockEntity.createLighter()).stream()).toList();
                BufferBuilder builder = new BufferBuilder(256);
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
                for (Consumer quad : quads) {
                    quad.accept(builder);
                }
                BufferBuilder.RenderedBuffer meshData = builder.m_231175_();
                blockEntity.connectionRenderBufferCache = SuperBufferFactory.getInstance().create(meshData);
            }
            blockEntity.connectionRenderBufferCache.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        }
    }

    protected void renderSegments(BlockState state, PartialModel model, PoseStack ms, int length, MultiBufferSource buffer, int light) {
        for (int i = 0; i < length; ++i) {
            ms.m_85836_();
            ms.m_252880_(0.0f, 0.0f, (float)i);
            CachedBuffers.partial((PartialModel)model, (BlockState)state).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
            ms.m_85849_();
        }
    }

    protected int getRenderPriority(Vec3i relative) {
        return relative.m_123342_() * 10000 + relative.m_123341_() * 100 + relative.m_123343_();
    }

    public int m_142163_() {
        return 256;
    }

    public boolean shouldRenderOffScreen(GirderStrutBlockEntity blockEntity) {
        return true;
    }
}

