/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut;

import com.kipti.bnb.content.girder_strut.geometry.GirderGeometry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface IBlockEntityRelighter {
    public static final float ADJACENT_BLOCK_TOLERANCE = 0.3f;

    public BlockAndTintGetter getLevel();

    public BlockPos m_58899_();

    default public Function<Vector3f, Integer> createLighter() {
        return this.createLighter(this.m_58899_());
    }

    default public Function<Vector3f, Integer> createLighter(BlockPos blockPos) {
        return position -> {
            if (this.getLevel() == null) {
                return GirderGeometry.DEFAULT_LIGHT;
            }
            Matrix4f lightTransform = new Matrix4f().translate((float)blockPos.m_123341_(), (float)blockPos.m_123342_(), (float)blockPos.m_123343_());
            Vector3f lightPosition = lightTransform.transformPosition((Vector3fc)position, new Vector3f());
            List<BlockPos> positions = this.getClosePositions(lightPosition.x, lightPosition.y, lightPosition.z);
            return positions.stream().map(p -> LevelRenderer.m_109541_((BlockAndTintGetter)this.getLevel(), (BlockPos)p)).reduce(0, IBlockEntityRelighter::maximizeLight);
        };
    }

    default public Function<Vector3f, Integer> createGlobalLighter() {
        return position -> {
            if (this.getLevel() == null) {
                return GirderGeometry.DEFAULT_LIGHT;
            }
            List<BlockPos> positions = this.getClosePositions(position.x, position.y, position.z);
            return positions.stream().map(p -> LevelRenderer.m_109541_((BlockAndTintGetter)this.getLevel(), (BlockPos)p)).reduce(0, IBlockEntityRelighter::maximizeLight);
        };
    }

    private List<BlockPos> getClosePositions(float x, float y, float z) {
        float fx = x - (float)Math.round(x);
        float fy = y - (float)Math.round(y);
        float fz = z - (float)Math.round(z);
        BlockPos base = new BlockPos((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        positions.add(base);
        if (Math.abs(fx) < 0.3f) {
            positions.add(base.m_121945_(fx > 0.0f ? Direction.WEST : Direction.EAST));
        }
        if (Math.abs(fy) < 0.3f) {
            positions.add(base.m_121945_(fy > 0.0f ? Direction.DOWN : Direction.UP));
        }
        if (Math.abs(fz) < 0.3f) {
            positions.add(base.m_121945_(fz > 0.0f ? Direction.NORTH : Direction.SOUTH));
        }
        return positions;
    }

    public static int maximizeLight(int lightA, int lightB) {
        int blockA = lightA & 0xFFFF;
        int skyA = lightA >>> 16 & 0xFFFF;
        int blockB = lightB & 0xFFFF;
        int skyB = lightB >>> 16 & 0xFFFF;
        int block = Math.max(blockA, blockB);
        int sky = Math.max(skyA, skyB);
        return sky << 16 | block;
    }
}

