/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class MultiblockPlacer
extends Block {
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.m_61631_((String)"part", (int)1, (int)2);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}}};

    public int[][][] getMultiblockShape() {
        return this.MULTIBLOCK_SHAPE;
    }

    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public MultiblockPlacer(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)this.getMultiblockPart(), (Comparable)Integer.valueOf(1))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{this.getMultiblockPart()});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos OGpos = pContext.m_8083_();
        Direction direction = pContext.m_8125_();
        int[][][] multiblockShape = this.getMultiblockShape();
        int maxHeight = this.getMultiblockShape().length;
        int OGx = OGpos.m_123341_();
        int OGy = OGpos.m_123342_();
        int OGz = OGpos.m_123343_();
        int xOffset = 0;
        int zOffset = 0;
        if (OGpos.m_123342_() + maxHeight >= level.m_151558_()) {
            return null;
        }
        for (int y = 0; y < maxHeight; ++y) {
            for (int x = 0; x < multiblockShape[y].length; ++x) {
                for (int z = 0; z < multiblockShape[y][x].length; ++z) {
                    if (multiblockShape[y][x][z] == 0 || level.m_8055_(new BlockPos(OGx + (xOffset = this.getXOffset(direction, x, z)), OGy + y, OGz + (zOffset = this.getZOffset(direction, x, z)))).m_247087_()) continue;
                    return null;
                }
            }
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
    }

    protected int getXOffset(Direction facing, int x, int z) {
        int xOffset = 0;
        if (facing.equals((Object)Direction.NORTH)) {
            xOffset = x;
        }
        if (facing.equals((Object)Direction.SOUTH)) {
            xOffset = -x;
        }
        if (facing.equals((Object)Direction.EAST)) {
            xOffset = z;
        }
        if (facing.equals((Object)Direction.WEST)) {
            xOffset = -z;
        }
        return xOffset;
    }

    protected int getZOffset(Direction facing, int x, int z) {
        int zOffset = 0;
        if (facing.equals((Object)Direction.NORTH)) {
            zOffset = -z;
        }
        if (facing.equals((Object)Direction.SOUTH)) {
            zOffset = z;
        }
        if (facing.equals((Object)Direction.EAST)) {
            zOffset = x;
        }
        if (facing.equals((Object)Direction.WEST)) {
            zOffset = -x;
        }
        return zOffset;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos state1Pos = null;
        state1Pos = (Integer)pState.m_61143_((Property)this.getMultiblockPart()) != 1 ? this.findBlockState1(pPos, (LevelAccessor)pLevel) : pPos;
        if (state1Pos != null) {
            if (!this.m_7898_(pLevel.m_8055_(state1Pos), (LevelReader)pLevel, state1Pos)) {
                pLevel.m_46961_(pPos, true);
            }
        } else {
            pLevel.m_46961_(pPos, true);
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        BlockPos state1Pos = null;
        state1Pos = (Integer)pState.m_61143_((Property)this.getMultiblockPart()) != 1 ? this.findBlockState1(pCurrentPos, pLevel) : pCurrentPos;
        if (state1Pos != null) {
            if (!this.m_7898_(pLevel.m_8055_(state1Pos), (LevelReader)pLevel, state1Pos)) {
                pLevel.m_186460_(pCurrentPos, (Block)this, 0);
            }
        } else {
            pLevel.m_186460_(pCurrentPos, (Block)this, 0);
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (!pLevel.m_8055_(pPos).m_60713_((Block)this)) {
            return true;
        }
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        if ((Integer)pState.m_61143_((Property)this.getMultiblockPart()) != 1) {
            return true;
        }
        int OGx = pPos.m_123341_();
        int OGy = pPos.m_123342_();
        int OGz = pPos.m_123343_();
        int[][][] multiblockShape = this.getMultiblockShape();
        for (int y = 0; y < multiblockShape.length; ++y) {
            for (int x = 0; x < multiblockShape[y].length; ++x) {
                for (int z = 0; z < multiblockShape[y][x].length; ++z) {
                    int xOffset = this.getXOffset(facing, x, z);
                    int zOffset = this.getZOffset(facing, x, z);
                    int part = 0;
                    BlockState state = pLevel.m_8055_(new BlockPos(OGx + xOffset, OGy + y, OGz + zOffset));
                    if (state.m_61138_((Property)this.getMultiblockPart())) {
                        part = (Integer)state.m_61143_((Property)this.getMultiblockPart());
                    }
                    if (multiblockShape[y][x][z] == 0 || multiblockShape[y][x][z] == part) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected BlockPos findBlockState1(BlockPos currentPos, LevelAccessor level) {
        if (!level.m_8055_(currentPos).m_61138_((Property)FACING)) {
            return null;
        }
        Direction facing = (Direction)level.m_8055_(currentPos).m_61143_((Property)FACING);
        int[][][] multiblockShape = this.getMultiblockShape();
        int partNum = (Integer)level.m_8055_(currentPos).m_61143_((Property)this.getMultiblockPart());
        for (int y = 0; y < multiblockShape.length; ++y) {
            for (int x = 0; x < multiblockShape[y].length; ++x) {
                for (int z = 0; z < multiblockShape[y][x].length; ++z) {
                    if (multiblockShape[y][x][z] != partNum) continue;
                    int xOffset = -this.getXOffset(facing, x, z);
                    int zOffset = -this.getZOffset(facing, x, z);
                    BlockPos possibleState1 = new BlockPos(currentPos.m_123341_() + xOffset, currentPos.m_123342_() - y, currentPos.m_123343_() + zOffset);
                    if (!level.m_8055_(possibleState1).m_60713_(this.m_7374_()) || !((Direction)level.m_8055_(possibleState1).m_61143_((Property)FACING)).equals((Object)facing)) continue;
                    return possibleState1;
                }
            }
        }
        return null;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pLevel.f_46443_) {
            Direction direction = (Direction)pState.m_61143_((Property)FACING);
            int[][][] multiblockShape = this.getMultiblockShape();
            int OGx = pPos.m_123341_();
            int OGy = pPos.m_123342_();
            int OGz = pPos.m_123343_();
            if ((Integer)pState.m_61143_((Property)this.getMultiblockPart()) == 1 && !pOldState.m_60713_(this.m_7374_())) {
                for (int y = 0; y < multiblockShape.length; ++y) {
                    for (int x = 0; x < multiblockShape[y].length; ++x) {
                        for (int z = 0; z < multiblockShape[y][x].length; ++z) {
                            if (x + y + z == 0 || multiblockShape[y][x][z] == 0) continue;
                            int xOffset = this.getXOffset(direction, x, z);
                            int zOffset = this.getZOffset(direction, x, z);
                            pLevel.m_7731_(new BlockPos(OGx + xOffset, OGy + y, OGz + zOffset), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)this.getMultiblockPart(), (Comparable)Integer.valueOf(multiblockShape[y][x][z]))).m_61124_((Property)FACING, (Comparable)direction), 2);
                        }
                    }
                }
            }
        }
    }
}

